/*
 * Decompiled with CFR 0.152.
 */
package com.plm.controller;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.plm.model.OpinionInfo;
import com.plm.model.ProjectBase;
import com.plm.model.ProjectBaseView;
import com.plm.model.ProjectEndView;
import com.plm.model.ProjectFundsView;
import com.plm.model.ProjectMidView;
import com.plm.model.ProjectOtherView;
import com.plm.model.ProjectPlan;
import com.plm.model.ProjectProcessInfo;
import com.plm.model.ProjectStartView;
import com.plm.model.ProjectUser;
import com.plm.model.UserInfo;
import com.plm.model.WeeklyInfo;
import com.plm.model.WeeklyView;
import com.plm.service.IOpinionService;
import com.plm.service.IProjectBaseService;
import com.plm.service.IProjectExtendService;
import com.plm.service.IProjectPlanService;
import com.plm.service.IUserService;
import com.plm.service.IWeeklyService;
import com.plm.util.StringUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projectinfo"})
public class ProjectInfoController {
    @Resource
    private IProjectBaseService projectBaseService;
    @Resource
    private IProjectExtendService projectExtendService;
    @Resource
    private IProjectPlanService projectPlanService;
    @Resource
    private IWeeklyService weeklyService;
    @Resource
    private IOpinionService opinionService;
    @Resource
    private IUserService userService;
    private UserInfo user;

    @RequestMapping(value={"/addfunds"})
    @ResponseBody
    public Integer addfunds(HttpServletRequest request) {
        String pfundcontent = request.getParameter("pfundcontent");
        String projectId = request.getParameter("projectId");
        String fopinion = request.getParameter("fopinion");
        String fstatus = request.getParameter("fstatus");
        if (projectId != null && pfundcontent != null) {
            ProjectBase record = new ProjectBase();
            record.setPbId(Integer.valueOf(Integer.parseInt(projectId)));
            record.setfContent(pfundcontent);
            record.setfStatus(Integer.valueOf(1));
            return this.projectBaseService.editProject(record);
        }
        if (projectId != null && fopinion != null && fstatus != null) {
            ProjectBase record = new ProjectBase();
            record.setPbId(Integer.valueOf(Integer.parseInt(projectId)));
            record.setfOpinion(fopinion);
            record.setfOpinionTime(StringUtils.getDate());
            record.setfStatus(Integer.valueOf(Integer.parseInt(fstatus)));
            return this.projectBaseService.editProject(record);
        }
        if (projectId != null && fopinion == null && fstatus == null && pfundcontent == null) {
            ProjectBase record = new ProjectBase();
            record.setPbId(Integer.valueOf(Integer.parseInt(projectId)));
            record.setfOpinion("");
            record.setfOpinionTime(StringUtils.strToDate((String)"0000-00-00", (String)"yyyy-MM-dd"));
            record.setfStatus(Integer.valueOf(1));
            return this.projectBaseService.editProject(record);
        }
        return 0;
    }

    @RequestMapping(value={"/editfunds"})
    @ResponseBody
    public Integer editfunds(@RequestParam Integer projectId, @RequestParam String pfundcontent) {
        if (projectId != null && StringUtils.isNotNullString((String[])new String[]{pfundcontent})) {
            ProjectBase record = new ProjectBase();
            record.setPbId(projectId);
            record.setfContent(pfundcontent);
            record.setfStatus(Integer.valueOf(1));
            return this.projectBaseService.editProject(record);
        }
        return 0;
    }

    @RequestMapping(value={"/startlist"})
    public String startlist(HttpServletRequest request, Model model) throws ServletException, IOException {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String url = "index";
        if (user == null) {
            return "index";
        }
        switch (user.getRole()) {
            case 1: 
            case 2: {
                url = "manager/projectstartlist";
                break;
            }
            case 3: 
            case 4: {
                url = "tutor/projectstartlist";
                break;
            }
            case 5: {
                url = "student/projectstartlist";
            }
        }
        return url;
    }

    @RequestMapping(value={"/liststart"})
    @ResponseBody
    public PageInfo<ProjectStartView> liststart(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = null;
        list = user.getRole() == 1 ? this.projectExtendService.findProjectStartView() : (user.getRole() == 2 ? this.projectExtendService.findProjectStartView(user.getCollege()) : this.projectExtendService.findProjectStartView(user.getuId()));
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/addstart"})
    @ResponseBody
    public Integer addstart(HttpServletRequest request) {
        String psiResult;
        String psiPlan;
        String psiFeature;
        String psiContent;
        String psiReason;
        String psiBrief;
        String subject;
        String type;
        String level;
        String projectplan;
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String projectname = request.getParameter("projectname");
        if (!StringUtils.isNotNullString((String[])new String[]{projectname, projectplan = request.getParameter("projectplan"), level = request.getParameter("level"), type = request.getParameter("type"), subject = request.getParameter("subject"), psiBrief = request.getParameter("psiBrief"), psiReason = request.getParameter("psiReason"), psiContent = request.getParameter("psiContent"), psiFeature = request.getParameter("psiFeature"), psiPlan = request.getParameter("psiPlan"), psiResult = request.getParameter("psiResult")})) {
            return 0;
        }
        List list = this.projectBaseService.findprojectuserbyuser(user.getuId());
        if (list != null && list.size() > 0) {
            for (ProjectUser pu : list) {
                ProjectBase pb;
                if (pu.getuType() != 0 || (pb = this.projectBaseService.selectById(pu.getPbId())) == null || pb.getPpId() != Integer.parseInt(projectplan)) continue;
                return -2;
            }
        }
        ProjectBase projectBase = new ProjectBase();
        projectBase.setPpId(Integer.valueOf(Integer.parseInt(projectplan)));
        projectBase.setPbName(projectname);
        projectBase.setPbLevel(Integer.valueOf(Integer.parseInt(level)));
        projectBase.setPbType(Integer.valueOf(Integer.parseInt(type)));
        projectBase.setSubjectType(Integer.valueOf(Integer.parseInt(subject)));
        projectBase.setPsiBrief(psiBrief);
        projectBase.setPsiReason(psiReason);
        projectBase.setPsiContent(psiContent);
        projectBase.setPsiFeature(psiFeature);
        projectBase.setPsiPlan(psiPlan);
        projectBase.setPsiResult(psiResult);
        int flag = 0;
        flag = this.projectExtendService.addproject(projectBase);
        if (flag != 0 && flag != -1) {
            this.projectExtendService.addprojectuser(Integer.valueOf(flag), user.getuCode(), Integer.valueOf(0));
        }
        return flag;
    }

    @RequestMapping(value={"/editstart"})
    @ResponseBody
    public Integer editstart(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String projectid = request.getParameter("projectid");
        String psiBrief = request.getParameter("psiBrief");
        String psiReason = request.getParameter("psiReason");
        String psiContent = request.getParameter("psiContent");
        String psiFeature = request.getParameter("psiFeature");
        String psiPlan = request.getParameter("psiPlan");
        String psiResult = request.getParameter("psiResult");
        if (!StringUtils.isNotNullString((String[])new String[]{projectid, psiBrief, psiReason, psiContent, psiFeature, psiPlan, psiResult})) {
            return 0;
        }
        ProjectBase projectBase = new ProjectBase();
        projectBase.setPbId(Integer.valueOf(Integer.parseInt(projectid)));
        projectBase.setPsiBrief(psiBrief);
        projectBase.setPsiReason(psiReason);
        projectBase.setPsiContent(psiContent);
        projectBase.setPsiFeature(psiFeature);
        projectBase.setPsiPlan(psiPlan);
        projectBase.setPsiResult(psiResult);
        projectBase.setPbEditTime(StringUtils.getDate());
        projectBase.setPsiOStatus(Integer.valueOf(11));
        return this.projectBaseService.editProject(projectBase);
    }

    @RequestMapping(value={"/deletestart"})
    @ResponseBody
    public Integer deletestart(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String projectid = request.getParameter("projectid");
        if (projectid == null) {
            return 0;
        }
        return this.projectBaseService.deleteProject(Integer.valueOf(Integer.parseInt(projectid)));
    }

    @RequestMapping(value={"/midlist"})
    public String midlist(HttpServletRequest request, Model model) throws ServletException, IOException {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String url = "index";
        if (user == null) {
            return "index";
        }
        switch (user.getRole()) {
            case 1: 
            case 2: {
                url = "manager/projectmidlist";
                break;
            }
            case 3: 
            case 4: {
                url = "tutor/projectmidlist";
                break;
            }
            case 5: {
                url = "student/projectmidlist";
            }
        }
        return url;
    }

    @RequestMapping(value={"/listmid"})
    @ResponseBody
    public PageInfo<ProjectMidView> listmid(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = null;
        list = user.getRole() == 1 ? this.projectExtendService.findProjectMidView() : (user.getRole() == 2 ? this.projectExtendService.findProjectMidView(user.getCollege()) : this.projectExtendService.findProjectMidView(user.getuId()));
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/midinfo"})
    @ResponseBody
    public ProjectMidView midinfo(@RequestParam Integer ppiId, HttpServletRequest request) {
        ProjectMidView info = this.projectExtendService.findProjectMidViewDetail(ppiId);
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/addmid"})
    @ResponseBody
    public Integer addmid(HttpServletRequest request) {
        String pmiIssue;
        String pmiContent;
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String projectid = request.getParameter("projectid");
        if (!StringUtils.isNotNullString((String[])new String[]{projectid, pmiContent = request.getParameter("pmiContent"), pmiIssue = request.getParameter("pmiIssue")})) {
            return 0;
        }
        List list = this.projectExtendService.findProjectMidView(user.getuId());
        if (list != null) {
            for (ProjectMidView pm : list) {
                if (pm.getPbId() != Integer.parseInt(projectid)) continue;
                if (pm.getPmiOStatus() == 21 || pm.getPmiOStatus() == 23 || pm.getPmiOStatus() == 25 || pm.getPmiOStatus() == 27 || pm.getPmiOStatus() == 29) {
                    return -1;
                }
                this.projectExtendService.deleteProcessInfo(pm.getPpiId());
            }
        }
        ProjectMidView pmid = new ProjectMidView();
        pmid.setPbId(Integer.valueOf(Integer.parseInt(projectid)));
        pmid.setPmiContent(pmiContent);
        pmid.setPmiIssue(pmiIssue);
        return this.projectExtendService.addmidprocess(pmid);
    }

    @RequestMapping(value={"/editmid"})
    @ResponseBody
    public Integer editmid(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String ppiId = request.getParameter("ppiId");
        String pmiContent = request.getParameter("pmiContent");
        String pmiIssue = request.getParameter("pmiIssue");
        if (!StringUtils.isNotNullString((String[])new String[]{ppiId, pmiContent, pmiIssue})) {
            return 0;
        }
        ProjectProcessInfo ppi = new ProjectProcessInfo();
        ppi.setPpiId(Integer.valueOf(Integer.parseInt(ppiId)));
        ppi.setPmiContent(pmiContent);
        ppi.setPmiIssue(pmiIssue);
        ppi.setPpiEditTime(StringUtils.getDate());
        return this.projectExtendService.editProcessInfo(ppi);
    }

    @RequestMapping(value={"/deletemid"})
    @ResponseBody
    public Integer deletemid(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String ppiId = request.getParameter("ppiId");
        if (ppiId == null) {
            return 0;
        }
        return this.projectExtendService.deleteProcessInfo(Integer.valueOf(Integer.parseInt(ppiId)));
    }

    @RequestMapping(value={"/checkinfo"})
    @ResponseBody
    public List<OpinionInfo> checkinfo(@RequestParam Integer ppiId, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        List info = this.opinionService.findOpinion(ppiId.intValue());
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/checkoneinfo"})
    @ResponseBody
    public OpinionInfo checkoneinfo(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        String ppiId = request.getParameter("ppiId");
        String outype = request.getParameter("outype");
        if (!StringUtils.isNotNullString((String[])new String[]{ppiId, outype})) {
            return null;
        }
        OpinionInfo info = this.opinionService.findOpinion(Integer.parseInt(ppiId), Integer.parseInt(outype));
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/addopinion"})
    @ResponseBody
    public Integer addopinion(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String ppiId = request.getParameter("ppiId");
        String outype = request.getParameter("outype");
        String oContent = request.getParameter("oContent");
        String oStatus = request.getParameter("oStatus");
        String oid = request.getParameter("oid");
        OpinionInfo opinfo = new OpinionInfo();
        try {
            if (StringUtils.isNotNullString((String[])new String[]{ppiId, outype, oContent, oStatus, oid})) {
                opinfo.setoId(Integer.valueOf(Integer.parseInt(oid)));
                opinfo.setPpiId(Integer.valueOf(Integer.parseInt(ppiId)));
                opinfo.setoUType(Integer.valueOf(Integer.parseInt(outype)));
                opinfo.setoContent(oContent);
                opinfo.setoStatus(Integer.valueOf(Integer.parseInt(oStatus)));
                return this.projectExtendService.editopinion(opinfo);
            }
            if (StringUtils.isNotNullString((String[])new String[]{ppiId, outype, oContent, oStatus})) {
                opinfo.setPpiId(Integer.valueOf(Integer.parseInt(ppiId)));
                opinfo.setoUType(Integer.valueOf(Integer.parseInt(outype)));
                opinfo.setoContent(oContent);
                opinfo.setoStatus(Integer.valueOf(Integer.parseInt(oStatus)));
                return this.projectExtendService.addopinion(opinfo);
            }
        }
        catch (Exception e) {
            return -2;
        }
        return -1;
    }

    @RequestMapping(value={"/deleteopinion"})
    @ResponseBody
    public Integer deleteopinion(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String oid = request.getParameter("oid");
        if (oid == null) {
            return -1;
        }
        String pId = request.getParameter("pId");
        String type = request.getParameter("type");
        String outype = request.getParameter("outype");
        if (pId == null || type == null || outype == null) {
            return 0;
        }
        int flag = 0;
        flag = this.opinionService.deleteOpinion(Integer.valueOf(Integer.parseInt(oid)));
        if (flag == 1) {
            ProjectBase info = this.projectBaseService.selectById(Integer.valueOf(Integer.parseInt(pId)));
            ProjectBase newinfo = new ProjectBase();
            if (info != null) {
                newinfo.setPbId(info.getPbId());
                if (type.equals("1")) {
                    if (outype.equals("0")) {
                        newinfo.setPsiOStatus(Integer.valueOf(11));
                    } else if (outype.equals("1")) {
                        newinfo.setPsiOStatus(Integer.valueOf(17));
                    } else if (outype.equals("2")) {
                        newinfo.setPsiOStatus(Integer.valueOf(13));
                    } else if (outype.equals("3")) {
                        newinfo.setPsiOStatus(Integer.valueOf(15));
                    }
                } else if (type.equals("2")) {
                    if (outype.equals("0")) {
                        newinfo.setPmiOStatus(Integer.valueOf(21));
                    } else if (outype.equals("1")) {
                        newinfo.setPmiOStatus(Integer.valueOf(27));
                    } else if (outype.equals("2")) {
                        newinfo.setPmiOStatus(Integer.valueOf(23));
                    } else if (outype.equals("3")) {
                        newinfo.setPmiOStatus(Integer.valueOf(25));
                    }
                } else if (type.equals("3")) {
                    if (outype.equals("0")) {
                        newinfo.setPeiOStatus(Integer.valueOf(31));
                    } else if (outype.equals("1")) {
                        newinfo.setPeiOStatus(Integer.valueOf(37));
                    } else if (outype.equals("2")) {
                        newinfo.setPeiOStatus(Integer.valueOf(33));
                    } else if (outype.equals("3")) {
                        newinfo.setPeiOStatus(Integer.valueOf(35));
                    }
                } else if (type.equals("4")) {
                    if (outype.equals("0")) {
                        newinfo.setPoiOStatus(Integer.valueOf(41));
                    } else if (outype.equals("1")) {
                        newinfo.setPoiOStatus(Integer.valueOf(47));
                    } else if (outype.equals("2")) {
                        newinfo.setPoiOStatus(Integer.valueOf(43));
                    } else if (outype.equals("3")) {
                        newinfo.setPoiOStatus(Integer.valueOf(45));
                    }
                }
            }
            this.projectBaseService.editProject(newinfo);
        }
        return flag;
    }

    @RequestMapping(value={"/endlist"})
    public String endlist(HttpServletRequest request, Model model) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String url = "index";
        if (user == null) {
            return "index";
        }
        switch (user.getRole()) {
            case 1: 
            case 2: {
                url = "manager/projectendlist";
                break;
            }
            case 3: 
            case 4: {
                url = "tutor/projectendlist";
                break;
            }
            case 5: {
                url = "student/projectendlist";
            }
        }
        return url;
    }

    @RequestMapping(value={"/listend"})
    @ResponseBody
    public PageInfo<ProjectEndView> listend(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = null;
        list = user.getRole() == 1 ? this.projectExtendService.findProjectEndView() : (user.getRole() == 2 ? this.projectExtendService.findProjectEndView(user.getCollege()) : this.projectExtendService.findProjectEndView(user.getuId()));
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/endinfo"})
    @ResponseBody
    public ProjectEndView endinfo(@RequestParam Integer ppiId, HttpServletRequest request) {
        ProjectEndView info = this.projectExtendService.findProjectEndViewDetail(ppiId);
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/addend"})
    @ResponseBody
    public Integer addend(HttpServletRequest request) {
        String peiOpoinion;
        String peiMission;
        String pmiContent;
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String projectid = request.getParameter("projectid");
        if (!StringUtils.isNotNullString((String[])new String[]{projectid, pmiContent = request.getParameter("pmiContent"), peiMission = request.getParameter("peiMission"), peiOpoinion = request.getParameter("peiOpoinion")})) {
            return 0;
        }
        List list = this.projectExtendService.findProjectEndView(user.getuId());
        if (list != null) {
            for (ProjectEndView pe : list) {
                if (pe.getPbId() != Integer.parseInt(projectid)) continue;
                if (pe.getPmiOStatus() == 31 || pe.getPmiOStatus() == 33 || pe.getPmiOStatus() == 35 || pe.getPmiOStatus() == 37 || pe.getPmiOStatus() == 39) {
                    return -1;
                }
                this.projectExtendService.deleteProcessInfo(pe.getPpiId());
            }
        }
        ProjectEndView peid = new ProjectEndView();
        peid.setPbId(Integer.valueOf(Integer.parseInt(projectid)));
        peid.setPmiContent(pmiContent);
        peid.setPeiLevel(Integer.valueOf(-1));
        peid.setPeiMission(peiMission);
        peid.setPeiOpoinion(peiOpoinion);
        return this.projectExtendService.addendprocess(peid);
    }

    @RequestMapping(value={"/editend"})
    @ResponseBody
    public Integer editend(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String ppiId = request.getParameter("ppiId");
        String pmiContent = request.getParameter("pmiContent");
        String peiMission = request.getParameter("peiMission");
        String peiOpoinion = request.getParameter("peiOpoinion");
        if (!StringUtils.isNotNullString((String[])new String[]{ppiId, pmiContent, peiMission, peiOpoinion})) {
            return 0;
        }
        ProjectProcessInfo ppi = new ProjectProcessInfo();
        ppi.setPpiId(Integer.valueOf(Integer.parseInt(ppiId)));
        ppi.setPmiContent(pmiContent);
        ppi.setPeiMission(peiMission);
        ppi.setPeiOpoinion(peiOpoinion);
        ppi.setPpiEditTime(StringUtils.getDate());
        return this.projectExtendService.editProcessInfo(ppi);
    }

    @RequestMapping(value={"/deleteend"})
    @ResponseBody
    public Integer deleteend(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String ppiId = request.getParameter("ppiId");
        if (ppiId == null) {
            return 0;
        }
        return this.projectExtendService.deleteProcessInfo(Integer.valueOf(Integer.parseInt(ppiId)));
    }

    @RequestMapping(value={"/otherlist"})
    public String otherlist(HttpServletRequest request, Model model) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String url = "index";
        if (user == null) {
            return "index";
        }
        switch (user.getRole()) {
            case 1: 
            case 2: {
                url = "manager/projectotherlist";
                break;
            }
            case 3: 
            case 4: {
                url = "tutor/projectotherlist";
                break;
            }
            case 5: {
                url = "student/projectotherlist";
            }
        }
        return url;
    }

    @RequestMapping(value={"/listother"})
    @ResponseBody
    public PageInfo<ProjectOtherView> listother(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = null;
        list = user.getRole() == 1 ? this.projectExtendService.findProjectOtherView() : (user.getRole() == 2 ? this.projectExtendService.findProjectOtherView(user.getCollege()) : this.projectExtendService.findProjectOtherView(user.getuId()));
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/otherinfo"})
    @ResponseBody
    public ProjectOtherView otherinfo(@RequestParam Integer ppiId, HttpServletRequest request) {
        ProjectOtherView info = this.projectExtendService.findProjectOtherViewDetail(ppiId);
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/addother"})
    @ResponseBody
    public Integer addother(HttpServletRequest request) {
        String poiType;
        String poiContent;
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String projectid = request.getParameter("projectid");
        if (!StringUtils.isNotNullString((String[])new String[]{projectid, poiContent = request.getParameter("poiContent"), poiType = request.getParameter("poiType")})) {
            return 0;
        }
        List list = this.projectExtendService.findProjectOtherView(user.getuId());
        if (list != null) {
            for (ProjectOtherView po : list) {
                if (po.getPbId() != Integer.parseInt(projectid)) continue;
                if (po.getPoiOStatus() == 43 || po.getPoiOStatus() == 45 || po.getPoiOStatus() == 47 || po.getPoiOStatus() == 49) {
                    return -1;
                }
                this.projectExtendService.deleteProcessInfo(po.getPpiId());
            }
        }
        ProjectOtherView poid = new ProjectOtherView();
        poid.setPbId(Integer.valueOf(Integer.parseInt(projectid)));
        poid.setPoiContent(poiContent);
        poid.setPoiType(Integer.valueOf(Integer.parseInt(poiType)));
        return this.projectExtendService.addotherprocess(poid);
    }

    @RequestMapping(value={"/editother"})
    @ResponseBody
    public Integer editother(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String ppiId = request.getParameter("ppiId");
        String poiContent = request.getParameter("poiContent");
        if (!StringUtils.isNotNullString((String[])new String[]{ppiId, poiContent})) {
            return 0;
        }
        ProjectProcessInfo ppi = new ProjectProcessInfo();
        ppi.setPpiId(Integer.valueOf(Integer.parseInt(ppiId)));
        ppi.setPoiContent(poiContent);
        ppi.setPpiEditTime(StringUtils.getDate());
        return this.projectExtendService.editProcessInfo(ppi);
    }

    @RequestMapping(value={"/deleteother"})
    @ResponseBody
    public Integer deleteother(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String ppiId = request.getParameter("ppiId");
        if (ppiId == null) {
            return 0;
        }
        return this.projectExtendService.deleteProcessInfo(Integer.valueOf(Integer.parseInt(ppiId)));
    }

    @RequestMapping(value={"/userprojectlist"})
    public String userprojectlist(HttpServletRequest request, Model model) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String url = "index";
        if (user == null) {
            return "index";
        }
        switch (user.getRole()) {
            case 3: 
            case 4: {
                url = "tutor/projectweeklylist";
                break;
            }
            case 5: {
                url = "student/projectweeklylist";
            }
        }
        return url;
    }

    @RequestMapping(value={"/listuserproject"})
    @ResponseBody
    public PageInfo<ProjectBaseView> listuserproject(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = this.projectBaseService.findProject(user);
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/projectinfo"})
    @ResponseBody
    public ProjectBase projectinfo(@RequestParam Integer pId, HttpServletRequest request) {
        ProjectBase info = this.projectBaseService.selectById(pId);
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/fundslist"})
    public String fundslist(HttpServletRequest request, Model model) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String url = "index";
        if (user == null) {
            return "index";
        }
        switch (user.getRole()) {
            case 1: 
            case 2: {
                url = "manager/projectfundslist";
                break;
            }
            case 5: {
                url = "student/projectfundslist";
            }
        }
        return url;
    }

    @RequestMapping(value={"/listfunds"})
    @ResponseBody
    public PageInfo<ProjectFundsView> listfunds(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = null;
        list = user.getRole() == 1 ? this.projectBaseService.findfunds() : (user.getRole() == 2 ? this.projectBaseService.findfunds(user.getCollege()) : this.projectBaseService.findfunds(user.getuId()));
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/fundsdetail"})
    @ResponseBody
    public ProjectFundsView fundsdetail(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String projectId = request.getParameter("projectId");
        if (user == null || !StringUtils.isNotNullString((String[])new String[]{projectId})) {
            return null;
        }
        ProjectFundsView info = null;
        info = this.projectBaseService.findfundsDetail(Integer.valueOf(Integer.parseInt(projectId)));
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/listweekly"})
    @ResponseBody
    public PageInfo<WeeklyView> listweekly(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, Integer projectId, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = this.weeklyService.findWeekly(user.getuId().intValue(), projectId.intValue());
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/listweeklynopage"})
    @ResponseBody
    public List<WeeklyView> listweeklynopage(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String projectId = request.getParameter("projectId");
        if (user == null || !StringUtils.isNotNullString((String[])new String[]{projectId})) {
            return null;
        }
        List list = this.weeklyService.findWeekly(user.getuId().intValue(), Integer.parseInt(projectId));
        if (list == null) {
            return null;
        }
        return list;
    }

    @RequestMapping(value={"/weeklydetail"})
    @ResponseBody
    public WeeklyInfo weeklydetail(HttpServletRequest request) {
        String weekId = request.getParameter("weekId");
        if (!StringUtils.isNotNullString((String[])new String[]{weekId})) {
            return null;
        }
        WeeklyInfo info = this.weeklyService.findWeekly(Integer.parseInt(weekId));
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/addweekly"})
    @ResponseBody
    public Integer addweekly(HttpServletRequest request) {
        String projectId = request.getParameter("projectId");
        String wStartTime = request.getParameter("wStartTime");
        String wEndTime = request.getParameter("wEndTime");
        String wThisWeek = request.getParameter("wThisWeek");
        String wNextWeek = request.getParameter("wNextWeek");
        if (projectId == null || wStartTime == null || wEndTime == null || wThisWeek == null || wNextWeek == null) {
            return 2;
        }
        WeeklyInfo weekly = new WeeklyInfo();
        weekly.setPbId(Integer.valueOf(Integer.parseInt(projectId)));
        weekly.setwStartTime(StringUtils.strToDate((String)wStartTime, (String)"yyyy-MM-dd"));
        weekly.setwEndTime(StringUtils.strToDate((String)wEndTime, (String)"yyyy-MM-dd"));
        weekly.setwThisWeek(wThisWeek);
        weekly.setwNextWeek(wNextWeek);
        weekly.setwStatus(Integer.valueOf(1));
        return this.weeklyService.addWeeklyInfo(weekly);
    }

    @RequestMapping(value={"/editweekly"})
    @ResponseBody
    public Integer editweekly(HttpServletRequest request) {
        String weekid = request.getParameter("weekid");
        String wThisWeek = request.getParameter("wThisWeek");
        String wNextWeek = request.getParameter("wNextWeek");
        String wopinion = request.getParameter("wopinion");
        String wstatus = request.getParameter("wstatus");
        WeeklyInfo weekly = new WeeklyInfo();
        if (weekid != null) {
            weekly.setwId(Integer.valueOf(Integer.parseInt(weekid)));
            if (wThisWeek == null || wNextWeek == null) {
                if (wopinion == null || wstatus == null) {
                    weekly.setwOpinion("");
                    weekly.setwStatus(Integer.valueOf(1));
                    return this.weeklyService.editWeeklyInfo(weekly);
                }
                weekly.setwOpinion(wopinion);
                weekly.setwStatus(Integer.valueOf(Integer.parseInt(wstatus)));
                return this.weeklyService.editWeeklyInfo(weekly);
            }
            weekly.setwThisWeek(wThisWeek);
            weekly.setwNextWeek(wNextWeek);
            weekly.setwStatus(Integer.valueOf(1));
            return this.weeklyService.editWeeklyInfo(weekly);
        }
        return 2;
    }

    @RequestMapping(value={"/deleteweekly"})
    @ResponseBody
    public Integer deleteweekly(@RequestParam Integer weeklyId) {
        return this.weeklyService.deleteWeeklyInfo(weeklyId.intValue());
    }

    @RequestMapping(value={"/projectplandetail"})
    @ResponseBody
    public ProjectPlan projectplandetail(@RequestParam Integer planid) {
        if (planid == null) {
            return null;
        }
        ProjectPlan info = this.projectPlanService.findProjectPlan(planid.intValue());
        if (info == null) {
            return null;
        }
        return info;
    }

    @RequestMapping(value={"/listprojectuserno"})
    @ResponseBody
    public List<ProjectBaseView> listprojectuser(@RequestParam Integer projectid) {
        if (projectid == null) {
            return null;
        }
        List list = this.projectBaseService.selectByPbid(projectid);
        if (list == null) {
            return null;
        }
        return list;
    }

    @RequestMapping(value={"/listprojectnopage"})
    @ResponseBody
    public List<ProjectBaseView> listprojectnopage(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        List list = this.projectBaseService.findProject(user);
        if (list == null) {
            return null;
        }
        return list;
    }

    @RequestMapping(value={"/recentproject"})
    @ResponseBody
    public ProjectBaseView recentproject(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        List list = this.projectBaseService.findProject(user);
        if (list == null) {
            return null;
        }
        return (ProjectBaseView)list.get(0);
    }

    @RequestMapping(value={"/projectmanager"})
    public String projectmanager(HttpServletRequest request, Model model) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return "index";
        }
        if (user.getRole() == 1 || user.getRole() == 2) {
            return "manager/projectmanager";
        }
        return "index";
    }

    @RequestMapping(value={"/changestatus"})
    @ResponseBody
    public Integer changestatus(@RequestParam Integer projectId, @RequestParam Integer pstatus) {
        if (projectId != null && pstatus != null) {
            ProjectBase record = new ProjectBase();
            record.setPbId(projectId);
            if (pstatus == 0 || pstatus == 5) {
                record.setPbStatus(pstatus);
                return this.projectBaseService.editProject(record);
            }
            ProjectBase info = this.projectBaseService.selectById(projectId);
            if (info.getPeiOStatus() != null && info.getPeiOStatus() <= 39) {
                record.setPbStatus(Integer.valueOf(3));
                return this.projectBaseService.editProject(record);
            }
            if (info.getPmiOStatus() != null && info.getPmiOStatus() <= 29) {
                record.setPbStatus(Integer.valueOf(2));
                return this.projectBaseService.editProject(record);
            }
            if (info.getPsiOStatus() != null && info.getPsiOStatus() <= 19) {
                record.setPbStatus(Integer.valueOf(1));
                return this.projectBaseService.editProject(record);
            }
            record.setPbStatus(Integer.valueOf(1));
            return this.projectBaseService.editProject(record);
        }
        return 0;
    }

    @RequestMapping(value={"/addstudent"})
    @ResponseBody
    public Integer addstudent(HttpServletRequest request) {
        String ucode = request.getParameter("ucode");
        String ppid = request.getParameter("ppid");
        String pId = request.getParameter("pId");
        UserInfo loginuser = (UserInfo)request.getSession().getAttribute("user");
        if (ucode == null || ppid == null || pId == null) {
            return 0;
        }
        this.user = this.userService.selectUserByuCode(ucode);
        if (this.user == null) {
            return -1;
        }
        if (this.user.getRole() != 5) {
            return -6;
        }
        if (this.user.getuId() == loginuser.getuId()) {
            return -7;
        }
        ProjectPlan pplan = this.projectPlanService.findProjectPlan(Integer.parseInt(ppid));
        if (pplan == null) {
            return -2;
        }
        if (pplan.getAcceptTime().getTime() > this.user.getAdmissionDate().getTime()) {
            return -3;
        }
        List list = this.projectBaseService.selectByPbid(Integer.valueOf(Integer.parseInt(pId)));
        int stuNum = 0;
        for (ProjectBaseView pb : list) {
            if (pb.getuType() != 0 && pb.getuType() != 1) continue;
            ++stuNum;
        }
        if (pplan.getStuNum() <= stuNum) {
            return -5;
        }
        return this.projectExtendService.addprojectuser(Integer.valueOf(Integer.parseInt(pId)), ucode, Integer.valueOf(1));
    }

    @RequestMapping(value={"/addteacher"})
    @ResponseBody
    public Integer addteacher(HttpServletRequest request) {
        String ucode = request.getParameter("ucode");
        String ppid = request.getParameter("ppid");
        String pId = request.getParameter("pId");
        String type = request.getParameter("type");
        if (ucode == null || ppid == null || pId == null) {
            return 0;
        }
        this.user = this.userService.selectUserByuCode(ucode);
        if (this.user == null) {
            return -1;
        }
        if (type == null) {
            if (this.user.getRole() != 4) {
                return -8;
            }
            ProjectPlan pplan = this.projectPlanService.findProjectPlan(Integer.parseInt(ppid));
            if (pplan == null) {
                return -2;
            }
            List list = this.projectBaseService.selectByPbid(Integer.valueOf(Integer.parseInt(pId)));
            int tuStuNum = 0;
            for (ProjectBaseView pb : list) {
                if (pb.getuType() != 0 && pb.getuType() != 1) continue;
                ++tuStuNum;
            }
            if (pplan.getTuStuNum() <= tuStuNum) {
                return -4;
            }
            return this.projectExtendService.addprojectuser(Integer.valueOf(Integer.parseInt(pId)), ucode, Integer.valueOf(2));
        }
        if (this.user.getRole() != 3) {
            return -8;
        }
        return this.projectExtendService.addprojectuser(Integer.valueOf(Integer.parseInt(pId)), ucode, Integer.valueOf(3));
    }

    @RequestMapping(value={"/deleteprojectuser"})
    @ResponseBody
    public Integer deleteprojectuser(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String puId = request.getParameter("puId");
        if (puId == null) {
            return 0;
        }
        return this.projectBaseService.deleteprojectuser(Integer.valueOf(Integer.parseInt(puId)));
    }
}

