/*
 * Decompiled with CFR 0.152.
 */
package com.plm.controller;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.plm.model.PostInfo;
import com.plm.model.PostView;
import com.plm.model.ProjectPlan;
import com.plm.model.UserInfo;
import com.plm.service.IPostService;
import com.plm.service.IProjectPlanService;
import com.plm.util.StringUtils;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProjectProcessController {
    @Resource
    private IPostService postService;
    @Resource
    private IProjectPlanService projectPlanService;

    @RequestMapping(value={"/postlist"})
    public String postlist(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return "postlist";
        }
        if (user.getRole() == 1 || user.getRole() == 2) {
            return "manager/postlist";
        }
        return "postlist";
    }

    @RequestMapping(value={"/postdetail"})
    public String postdetail(HttpServletRequest request) {
        String piId = request.getParameter("piId");
        if (!StringUtils.isNotNullString((String[])new String[]{piId})) {
            return "postlist";
        }
        request.getSession().setAttribute("piId", (Object)piId);
        return "postdetail";
    }

    @RequestMapping(value={"/postinfo"})
    @ResponseBody
    public PostView postinfo(HttpServletRequest request) {
        String piId = request.getParameter("piId");
        if (StringUtils.isNotNullString((String[])new String[]{piId})) {
            PostView postinfo = this.postService.findbyPostid(Integer.parseInt(piId));
            return postinfo;
        }
        return null;
    }

    @RequestMapping(value={"/listPost"})
    @ResponseBody
    public PageInfo<PostView> listPost(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List listPost = this.postService.findPost();
        PageInfo p = new PageInfo(listPost);
        return p;
    }

    @RequestMapping(value={"/addpost"})
    @ResponseBody
    public Integer addpost(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String postname = request.getParameter("postname");
        String postcontent = request.getParameter("postcontent");
        String postid = request.getParameter("postid");
        PostInfo postInfo = new PostInfo();
        PostInfo post = this.postService.findPostBytitle(postname);
        try {
            if (StringUtils.isNotNullString((String[])new String[]{postname, postcontent, postid})) {
                if (post != null && !postname.equals(post.getPiTitle())) {
                    return -2;
                }
                postInfo.setPiId(Integer.valueOf(Integer.parseInt(postid)));
                postInfo.setPiContent(postcontent);
                postInfo.setPiTitle(postname);
                postInfo.setPostEditTime(StringUtils.getDate());
                return this.postService.editPost(postInfo);
            }
            if (StringUtils.isNotNullString((String[])new String[]{postname, postcontent})) {
                if (post != null) {
                    return -2;
                }
                postInfo.setuId(user.getuId());
                postInfo.setPiContent(postcontent);
                postInfo.setPiTitle(postname);
                postInfo.setPostTime(StringUtils.getDate());
                postInfo.setPostEditTime(StringUtils.getDate());
                return this.postService.addPost(postInfo);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    @RequestMapping(value={"/deletepost"})
    @ResponseBody
    public Integer deletepost(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String postid = request.getParameter("postid");
        if (postid == null) {
            return 0;
        }
        try {
            return this.postService.deletePost(Integer.parseInt(postid));
        }
        catch (Exception e) {
            return -1;
        }
    }

    @RequestMapping(value={"/planlist"})
    public String planlist(HttpServletRequest request) {
        return "manager/planlist";
    }

    @RequestMapping(value={"/listPlan"})
    @ResponseBody
    public PageInfo<ProjectPlan> listPlan(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        PageHelper.startPage((int)page, (int)pageSize);
        List list = null;
        if (user != null && (user.getRole() == 1 || user.getRole() == 2)) {
            list = this.projectPlanService.findProjectPlanAll();
        } else if (user != null && user.getRole() == 5) {
            list = this.projectPlanService.findProjectPlanByUser(user);
        }
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/listPlanNopage"})
    @ResponseBody
    public List<ProjectPlan> listPlanNopage(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        List list = null;
        if (user != null && (user.getRole() == 1 || user.getRole() == 2)) {
            list = this.projectPlanService.findProjectPlanAll();
        } else if (user != null && user.getRole() == 5) {
            list = this.projectPlanService.findProjectPlanByUser(user);
        }
        if (list == null) {
            return null;
        }
        return list;
    }

    @RequestMapping(value={"/addplan"})
    @ResponseBody
    public Integer addplan(HttpServletRequest request) {
        String ppName = request.getParameter("ppName");
        String ppYear = request.getParameter("ppYear");
        String startTime = request.getParameter("startTime");
        String midTime = request.getParameter("midTime");
        String endTime = request.getParameter("endTime");
        String stuNum = request.getParameter("stuNum");
        String acceptTime = request.getParameter("acceptTime");
        String tuStuNum = request.getParameter("tuStuNum");
        ProjectPlan plan = null;
        if (StringUtils.isNotNullString((String[])new String[]{ppName, ppYear, startTime, midTime, endTime, stuNum, acceptTime, tuStuNum})) {
            plan = new ProjectPlan();
            plan.setPpName(ppName);
            plan.setPpYear(ppYear);
            try {
                plan.setPpStartTime(StringUtils.strToDate((String)startTime, (String)"yyyy-MM-dd"));
                plan.setPpMidTime(StringUtils.strToDate((String)midTime, (String)"yyyy-MM-dd"));
                plan.setPpEndTime(StringUtils.strToDate((String)endTime, (String)"yyyy-MM-dd"));
                plan.setStuNum(Integer.valueOf(Integer.parseInt(stuNum)));
                plan.setAcceptTime(StringUtils.strToDate((String)acceptTime, (String)"yyyy-MM-dd"));
                plan.setTuStuNum(Integer.valueOf(Integer.parseInt(tuStuNum)));
            }
            catch (Exception e) {
                return 0;
            }
        } else {
            return 0;
        }
        return this.projectPlanService.addProjectPlan(plan);
    }

    @RequestMapping(value={"/editplan"})
    @ResponseBody
    public Integer editplan(HttpServletRequest request) {
        String ppId = request.getParameter("ppId");
        String ppName = request.getParameter("ppName");
        String ppYear = request.getParameter("ppYear");
        String startTime = request.getParameter("startTime");
        String midTime = request.getParameter("midTime");
        String endTime = request.getParameter("endTime");
        String stuNum = request.getParameter("stuNum");
        String acceptTime = request.getParameter("acceptTime");
        String tuStuNum = request.getParameter("tuStuNum");
        ProjectPlan plan = null;
        if (StringUtils.isNotNullString((String[])new String[]{ppId, ppName, ppYear, startTime, midTime, endTime, stuNum, acceptTime, tuStuNum})) {
            plan = new ProjectPlan();
            plan.setPpName(ppName);
            plan.setPpYear(ppYear);
            try {
                plan.setPpId(Integer.valueOf(Integer.parseInt(ppId)));
                plan.setPpStartTime(StringUtils.strToDate((String)startTime, (String)"yyyy-MM-dd"));
                plan.setPpMidTime(StringUtils.strToDate((String)midTime, (String)"yyyy-MM-dd"));
                plan.setPpEndTime(StringUtils.strToDate((String)endTime, (String)"yyyy-MM-dd"));
                plan.setStuNum(Integer.valueOf(Integer.parseInt(stuNum)));
                plan.setAcceptTime(StringUtils.strToDate((String)acceptTime, (String)"yyyy-MM-dd"));
                plan.setTuStuNum(Integer.valueOf(Integer.parseInt(tuStuNum)));
            }
            catch (Exception e) {
                return 0;
            }
        } else {
            return 0;
        }
        return this.projectPlanService.editProjectPlan(plan);
    }

    @RequestMapping(value={"/deleteplan"})
    @ResponseBody
    public Integer deleteplan(HttpServletRequest request) {
        String ppId = request.getParameter("ppId");
        if (StringUtils.isNotNullString((String[])new String[]{ppId})) {
            try {
                return this.projectPlanService.deleteProjectPlan(Integer.parseInt(ppId));
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }
}

