/*
 * Decompiled with CFR 0.152.
 */
package com.plm.controller;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.plm.model.HelpInfo;
import com.plm.model.LinksInfo;
import com.plm.model.ProjectBase;
import com.plm.model.SiteFileInfo;
import com.plm.model.UserInfo;
import com.plm.service.IProjectBaseService;
import com.plm.service.ISiteInfoService;
import com.plm.util.FileOperateUtils;
import com.plm.util.StringUtils;
import com.plm.util.WordUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SiteInfoController {
    @Resource
    private ISiteInfoService siteInfoServeice;
    @Resource
    private IProjectBaseService projectBaseService;

    @RequestMapping(value={"/index"})
    public String index(HttpServletRequest request) {
        return "index";
    }

    @RequestMapping(value={"/excellentProjectlist"})
    public String excellentProjectlist(HttpServletRequest request) {
        return "excellentlist";
    }

    @RequestMapping(value={"/listexcellentProject"})
    @ResponseBody
    public PageInfo<ProjectBase> listexcellentProject(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List list = this.projectBaseService.findExcellentProject();
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/filelist"})
    public String filelist(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return "filelist";
        }
        if (user.getRole() == 0) {
            return "admin/filelist";
        }
        return "filelist";
    }

    @RequestMapping(value={"/listfile"})
    @ResponseBody
    public PageInfo<SiteFileInfo> listfile(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List list = this.siteInfoServeice.selectFileAll();
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/addfile"})
    @ResponseBody
    public Integer addfile(HttpServletRequest request) {
        SiteFileInfo sitefile;
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String info = (String)request.getAttribute("info");
        if (info != null && "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01".equals(info) && (sitefile = (SiteFileInfo)request.getAttribute("sitefile")) != null) {
            return this.siteInfoServeice.insertFile(sitefile);
        }
        return -1;
    }

    @RequestMapping(value={"/fileinfo"})
    @ResponseBody
    public SiteFileInfo fileinfo(HttpServletRequest request) {
        String fileid = request.getParameter("fileid");
        if (StringUtils.isNotNullString((String[])new String[]{fileid})) {
            SiteFileInfo info = this.siteInfoServeice.selectFileById(Integer.valueOf(Integer.parseInt(fileid)));
            return info;
        }
        return null;
    }

    @RequestMapping(value={"/deletefile"})
    @ResponseBody
    public Integer deletefile(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String fileid = request.getParameter("fileid");
        if (fileid == null) {
            return 0;
        }
        try {
            SiteFileInfo info = this.siteInfoServeice.selectFileById(Integer.valueOf(Integer.parseInt(fileid)));
            if (info != null) {
                FileOperateUtils.delAllFile((String)info.getSfPath());
            }
            return this.siteInfoServeice.deleteFileById(Integer.valueOf(Integer.parseInt(fileid)));
        }
        catch (Exception e) {
            return -1;
        }
    }

    @RequestMapping(value={"/helplist"})
    public String helplist(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return "helplist";
        }
        if (user.getRole() == 0) {
            return "admin/helplist";
        }
        return "helplist";
    }

    @RequestMapping(value={"/listhelp"})
    @ResponseBody
    public PageInfo<HelpInfo> listhelp(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List list = this.siteInfoServeice.selectHelpAll();
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/helpinfo"})
    @ResponseBody
    public HelpInfo helpinfo(HttpServletRequest request) {
        String helpid = request.getParameter("helpid");
        if (StringUtils.isNotNullString((String[])new String[]{helpid})) {
            HelpInfo info = this.siteInfoServeice.selectHelpById(Integer.valueOf(Integer.parseInt(helpid)));
            return info;
        }
        return null;
    }

    @RequestMapping(value={"/deletehelp"})
    @ResponseBody
    public Integer deletehelp(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String helpid = request.getParameter("helpid");
        if (helpid == null) {
            return 0;
        }
        try {
            return this.siteInfoServeice.deleteHelpById(Integer.valueOf(Integer.parseInt(helpid)));
        }
        catch (Exception e) {
            return -1;
        }
    }

    @RequestMapping(value={"/addhelp"})
    @ResponseBody
    public Integer addhelp(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String helptitle = request.getParameter("helptitle");
        String helptype = request.getParameter("helptype");
        String helpcontent = request.getParameter("helpcontent");
        String helpid = request.getParameter("helpid");
        HelpInfo info = new HelpInfo();
        try {
            if (StringUtils.isNotNullString((String[])new String[]{helptitle, helptype, helpcontent, helpid})) {
                info.sethId(Integer.valueOf(Integer.parseInt(helpid)));
                info.sethTitle(helptitle);
                info.sethType(helptype);
                info.sethContent(helpcontent);
                return this.siteInfoServeice.updateHelpByIdSelective(info);
            }
            if (StringUtils.isNotNullString((String[])new String[]{helptitle, helptype, helpcontent})) {
                info.sethTitle(helptitle);
                info.sethType(helptype);
                info.sethContent(helpcontent);
                return this.siteInfoServeice.insertHelpSelective(info);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    @RequestMapping(value={"/linklist"})
    public String listlink(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return "linklist";
        }
        if (user.getRole() == 0) {
            return "admin/linklist";
        }
        return "linklist";
    }

    @RequestMapping(value={"/listLinks"})
    @ResponseBody
    public PageInfo<LinksInfo> listLiks(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List linkList = this.siteInfoServeice.selectLinkAll();
        PageInfo p = new PageInfo(linkList);
        return p;
    }

    @RequestMapping(value={"/linkinfo"})
    @ResponseBody
    public LinksInfo linkinfo(HttpServletRequest request) {
        String linkid = request.getParameter("linkid");
        if (StringUtils.isNotNullString((String[])new String[]{linkid})) {
            LinksInfo linkinfo = this.siteInfoServeice.selectLinkById(Integer.valueOf(Integer.parseInt(linkid)));
            return linkinfo;
        }
        return null;
    }

    @RequestMapping(value={"/deletelink"})
    @ResponseBody
    public Integer deletelink(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String linkid = request.getParameter("linkid");
        if (linkid == null) {
            return 0;
        }
        try {
            return this.siteInfoServeice.deleteLinkById(Integer.valueOf(Integer.parseInt(linkid)));
        }
        catch (Exception e) {
            return -1;
        }
    }

    @RequestMapping(value={"/addlink"})
    @ResponseBody
    public Integer addlink(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String linkname = request.getParameter("linkname");
        String linkurl = request.getParameter("linkurl");
        String linkid = request.getParameter("linkid");
        LinksInfo linkinfo = new LinksInfo();
        LinksInfo link = this.siteInfoServeice.selectLinkByname(linkname);
        try {
            if (StringUtils.isNotNullString((String[])new String[]{linkname, linkurl, linkid})) {
                if (link != null && !linkname.equals(link.getLiName())) {
                    return -2;
                }
                linkinfo.setLiId(Integer.valueOf(Integer.parseInt(linkid)));
                linkinfo.setLiName(linkname);
                linkinfo.setLiUrl(linkurl);
                return this.siteInfoServeice.updateLinkByIdSelective(linkinfo);
            }
            if (StringUtils.isNotNullString((String[])new String[]{linkname, linkurl})) {
                if (link != null) {
                    return -2;
                }
                linkinfo.setLiName(linkname);
                linkinfo.setLiUrl(linkurl);
                return this.siteInfoServeice.insertLink(linkinfo);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    @RequestMapping(value={"/exportStart"})
    public void exportStart(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pId = request.getParameter("pId");
        ProjectBase info = this.projectBaseService.selectById(Integer.valueOf(Integer.parseInt(pId)));
        if (info == null) {
            return;
        }
        List list = this.projectBaseService.selectByPbid(Integer.valueOf(Integer.parseInt(pId)));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filename", "0001");
        map.put("title", "\u7acb\u9879\u4fe1\u606f");
        map.put("info", info);
        map.put("memberinfo", list);
        WordUtils.exportWord((HttpServletRequest)request, (HttpServletResponse)response, map);
    }
}

