/*
 * Decompiled with CFR 0.152.
 */
package com.plm.controller;

import com.plm.model.Pblevel;
import com.plm.model.Pbtype;
import com.plm.model.UserInfo;
import com.plm.service.IProjectExtendService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/statistics"})
public class StatisticsController {
    @Resource
    private IProjectExtendService projectExtendService;

    @RequestMapping(value={"/statistics"})
    public String index(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user != null && (user.getRole() == 1 || user.getRole() == 2)) {
            return "manager/statistics";
        }
        return "index";
    }

    @RequestMapping(value={"/pblevel"})
    @ResponseBody
    public Pblevel pblevel() {
        Pblevel level = this.projectExtendService.findpblevel();
        if (level == null) {
            return null;
        }
        return level;
    }

    @RequestMapping(value={"/pbtype"})
    @ResponseBody
    public Pbtype pbtype() {
        Pbtype type = this.projectExtendService.findpbtype();
        if (type == null) {
            return null;
        }
        return type;
    }

    @RequestMapping(value={"/pbsubject"})
    @ResponseBody
    public Pbtype pbsubject() {
        Pbtype type = this.projectExtendService.findpbsubject();
        if (type == null) {
            return null;
        }
        return type;
    }

    @RequestMapping(value={"/pbstatus"})
    @ResponseBody
    public Pbtype pbstatus() {
        Pbtype type = this.projectExtendService.findpbstatus();
        if (type == null) {
            return null;
        }
        return type;
    }

    @RequestMapping(value={"/pbplan"})
    @ResponseBody
    public List<Map<String, Object>> pbplan() {
        List list = this.projectExtendService.findpbplan();
        if (list == null) {
            return null;
        }
        return list;
    }

    @RequestMapping(value={"/pbstudent"})
    @ResponseBody
    public List<Map<String, Object>> pbstudent(HttpServletRequest request) {
        List list = this.projectExtendService.findpbstudent();
        if (list == null) {
            return null;
        }
        return list;
    }

    @RequestMapping(value={"/pbcolstudent"})
    @ResponseBody
    public List<Map<String, Object>> pbcolstudent(HttpServletRequest request) {
        String college = request.getParameter("college");
        if (college == null) {
            return null;
        }
        List list = this.projectExtendService.findpbcolstudent(college);
        if (list == null) {
            return null;
        }
        return list;
    }
}

