/*
 * Decompiled with CFR 0.152.
 */
package com.plm.controller;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.plm.model.UserInfo;
import com.plm.service.IProjectBaseService;
import com.plm.service.IUserService;
import com.plm.util.IMailService;
import com.plm.util.MD5Utils;
import com.plm.util.MailEntry;
import com.plm.util.PasswordUtils;
import com.plm.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.mail.internet.AddressException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController {
    @Resource
    private IUserService userService;
    private UserInfo user;
    @Resource
    private IMailService mailService;
    @Resource
    private IProjectBaseService projectBaseService;

    @RequestMapping(value={"/login"})
    public String login(HttpServletRequest request, Model model) throws ServletException, IOException {
        HttpSession session = request.getSession();
        this.user = (UserInfo)session.getAttribute("user");
        if (this.user != null) {
            session.removeAttribute("user");
        }
        return "login";
    }

    @RequestMapping(value={"/loginCheck"})
    public String loginCheck(HttpServletRequest request, Model model) throws ServletException, IOException {
        String url = "";
        request.getSession().removeAttribute("info");
        HttpSession session = request.getSession();
        this.user = (UserInfo)session.getAttribute("user");
        if (this.user == null) {
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            String verifyCode = request.getParameter("verifyCode");
            String code = (String)request.getSession().getAttribute("code");
            if (!StringUtils.isNotNullString((String[])new String[]{username, password, verifyCode})) {
                url = "redirect:/user/login";
                return url;
            }
            if (!verifyCode.equalsIgnoreCase(code)) {
                model.addAttribute("uname", (Object)username);
                model.addAttribute("info", (Object)"\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25");
                url = "login";
                return url;
            }
            String regEx = "^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(username);
            this.user = matcher.matches() ? this.userService.selectUserByEmail(username) : this.userService.selectUserByUsename(username);
            if (this.user == null) {
                model.addAttribute("info", (Object)"\u7528\u6237\u4e0d\u5b58\u5728");
                model.addAttribute("uname", (Object)username);
                url = "login";
                return url;
            }
            if (!this.user.getuPassword().equals(MD5Utils.stringEncoder((String)password))) {
                model.addAttribute("info", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                model.addAttribute("uname", (Object)username);
                url = "login";
                return url;
            }
            if (this.user.getStatus() != 1) {
                model.addAttribute("info", (Object)"\u8d26\u53f7\u672a\u6fc0\u6d3b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6fc0\u6d3b");
                url = "login";
                return url;
            }
            session.removeAttribute("code");
            session.setAttribute("user", (Object)this.user);
        }
        switch (this.user.getRole()) {
            case 0: {
                url = "admin/index";
                break;
            }
            case 1: 
            case 2: {
                url = "manager/index";
                break;
            }
            case 3: 
            case 4: {
                url = "tutor/index";
                break;
            }
            case 5: {
                url = "student/index";
            }
        }
        return url;
    }

    @RequestMapping(value={"/logout"})
    public String logout(HttpServletRequest request, Model model) throws ServletException, IOException {
        HttpSession session = request.getSession();
        this.user = (UserInfo)session.getAttribute("user");
        if (this.user != null) {
            session.removeAttribute("user");
        }
        return "redirect:/";
    }

    @RequestMapping(value={"/register"})
    public String register(HttpServletRequest request, Model model) throws ServletException, IOException {
        return "register";
    }

    @RequestMapping(value={"/registerCheck"})
    public String registerCheck(HttpServletRequest request, Model model) throws ServletException, IOException {
        String uName = request.getParameter("uName");
        String uRealname = request.getParameter("uRealname");
        String uPassword = request.getParameter("uPassword");
        String sex = request.getParameter("sex");
        String email = request.getParameter("email");
        String uCode = request.getParameter("uCode");
        String userType = request.getParameter("userType");
        if (!StringUtils.isNotNullString((String[])new String[]{uName, uRealname, uPassword, email, uCode, userType})) {
            model.addAttribute("info", (Object)"\u4f20\u53c2\u4e0d\u5b8c\u6574");
            model.addAttribute("uName", (Object)uName);
            model.addAttribute("uRealname", (Object)uRealname);
            model.addAttribute("email", (Object)email);
            model.addAttribute("uCode", (Object)uCode);
            return "register";
        }
        this.user = new UserInfo();
        this.user.setuName(uName);
        this.user.setuPassword(MD5Utils.stringEncoder((String)uPassword));
        this.user.setuRealname(uRealname);
        this.user.setGender(Integer.valueOf(Integer.parseInt(sex)));
        this.user.setEmail(email);
        this.user.setuCode(uCode);
        this.user.setStatus(Integer.valueOf(0));
        if (userType.equals("0")) {
            this.user.setRole(Integer.valueOf(5));
        } else {
            this.user.setRole(Integer.valueOf(4));
        }
        if (this.userService.selectUserByUsename(uName) != null) {
            model.addAttribute("info", (Object)"\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728");
            model.addAttribute("uRealname", (Object)uRealname);
            model.addAttribute("email", (Object)email);
            model.addAttribute("uCode", (Object)uCode);
        } else if (this.userService.selectUserByEmail(email) != null) {
            model.addAttribute("info", (Object)"\u8be5email\u5df2\u5b58\u5728");
            model.addAttribute("uName", (Object)uName);
            model.addAttribute("uRealname", (Object)uRealname);
            model.addAttribute("uCode", (Object)uCode);
        } else {
            if (userType.equals("0")) {
                if (this.userService.insertUserSelective(this.user) != 1) {
                    model.addAttribute("info", (Object)"\u670d\u52a1\u5668\u9519\u8bef\uff0c\u4fee\u6539\u5931\u8d25");
                    return "info";
                }
                this.user = this.userService.selectUserByEmail(email);
                request.getSession().setAttribute("userNew", (Object)this.user);
            } else {
                if (this.userService.insertUserSelective(this.user) != 1) {
                    model.addAttribute("info", (Object)"\u670d\u52a1\u5668\u9519\u8bef\uff0c\u4fee\u6539\u5931\u8d25");
                    return "info";
                }
                this.user = this.userService.selectUserByEmail(email);
                request.getSession().setAttribute("userNew", (Object)this.user);
            }
            return "register-detail";
        }
        return "register";
    }

    @RequestMapping(value={"/registerDetail"})
    public String registerDetail(HttpServletRequest request, Model model) throws ServletException, IOException {
        String tel;
        String note;
        String major;
        String userType = request.getParameter("userType");
        HttpSession session = request.getSession();
        this.user = (UserInfo)session.getAttribute("userNew");
        UserInfo userNew = new UserInfo();
        userNew.setuId(this.user.getuId());
        if (!StringUtils.isNotNullString((String[])new String[]{userType}) || this.user == null) {
            model.addAttribute("info", (Object)"\u4f20\u53c2\u9519\u8bef");
            return "info";
        }
        String college = request.getParameter("college");
        if (!StringUtils.isNotNullString((String[])new String[]{college, major = request.getParameter("major"), note = request.getParameter("note"), tel = request.getParameter("tel")})) {
            model.addAttribute("info", (Object)"\u4fe1\u606f\u4e0d\u8db3");
            return "info";
        }
        userNew.setCollege(college);
        userNew.setMajor(major);
        userNew.setTel(tel);
        if (userType.equals("0")) {
            userNew.setAdmissionDate(StringUtils.strToDate((String)note, (String)"yyyy-MM-dd"));
        } else if (userType.equals("1")) {
            userNew.setJobTitle(note);
        }
        System.out.println(this.user);
        if (this.userService.updateUserById(userNew) == 1) {
            model.addAttribute("info", (Object)"\u6ce8\u518c\u6210\u529f");
            return "login";
        }
        model.addAttribute("info", (Object)"\u670d\u52a1\u5668\u9519\u8bef");
        return "info";
    }

    @RequestMapping(value={"/reset"})
    public String reset(HttpServletRequest request, Model model) throws ServletException, IOException {
        return "forgot-password";
    }

    @RequestMapping(value={"/forgetPWD"})
    public String forgetPWD(HttpServletRequest request, Model model) throws ServletException, IOException {
        String email = request.getParameter("email");
        if (StringUtils.isNotNullString((String[])new String[]{email})) {
            this.user = this.userService.selectUserByEmail(email);
            if (this.user != null) {
                String content = PasswordUtils.createLink((UserInfo)this.user, (HttpServletRequest)request, (IUserService)this.userService);
                try {
                    MailEntry mail = new MailEntry();
                    mail.setSubject("\u91cd\u7f6e\u5bc6\u7801");
                    String[] addr = new String[]{this.user.getEmail()};
                    try {
                        mail.setRecipients(addr);
                    }
                    catch (AddressException e) {
                        e.printStackTrace();
                    }
                    mail.setText(content);
                    this.mailService.sendMail(mail);
                }
                catch (Exception e) {
                    model.addAttribute("info", (Object)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25");
                    return "forgot-password";
                }
                model.addAttribute("info", (Object)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
                return "info";
            }
        } else {
            model.addAttribute("info", (Object)"\u4f20\u53c2\u5931\u8d25");
            return "forgot-password";
        }
        model.addAttribute("info", (Object)"\u90ae\u7bb1\u5730\u5740\u4e0d\u5b58\u5728");
        return "forgot-password";
    }

    @RequestMapping(value={"/toResetPWD"})
    public String toResetPWD(HttpServletRequest request, Model model) throws ServletException, IOException {
        if ("\u9a8c\u8bc1\u6210\u529f".equals(PasswordUtils.toFindPassword((HttpServletRequest)request, (IUserService)this.userService))) {
            model.addAttribute("info", (Object)"\u9a8c\u8bc1\u6210\u529f");
            request.getSession().setAttribute("sid", (Object)request.getParameter("sid"));
            return "reset-password";
        }
        model.addAttribute("info", (Object)"\u9a8c\u8bc1\u5931\u8d25");
        return "info";
    }

    @RequestMapping(value={"/resetPWD"})
    public String resetPWD(@RequestParam(required=true) String id, @RequestParam(required=true) String password, HttpServletRequest request, Model model) throws ServletException, IOException {
        if ("\u9a8c\u8bc1\u6210\u529f".equals(PasswordUtils.toFindPassword((HttpServletRequest)request, (IUserService)this.userService))) {
            model.addAttribute("info", (Object)"\u9a8c\u8bc1\u6210\u529f");
            this.user = new UserInfo();
            this.user.setuId(Integer.valueOf(Integer.parseInt(id)));
            this.user.setuPassword(MD5Utils.stringEncoder((String)password));
            if (this.userService.updateUserById(this.user) != 1) {
                model.addAttribute("info", (Object)"\u670d\u52a1\u5668\u9519\u8bef\uff0c\u4fee\u6539\u5931\u8d25");
                return "index";
            }
            request.getSession().removeAttribute("sid");
            return "login";
        }
        model.addAttribute("info", (Object)"\u975e\u6cd5\u64cd\u4f5c");
        return "index";
    }

    @RequestMapping(value={"/userlist"})
    public String userlist(HttpServletRequest request, Model model) throws ServletException, IOException {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        String url = "redirect:/";
        if (user == null) {
            return "redirect:/";
        }
        switch (user.getRole()) {
            case 0: {
                url = "admin/usermanager";
                break;
            }
            case 1: 
            case 2: {
                url = "manager/usermanager";
                break;
            }
            default: {
                url = "redirect:/";
            }
        }
        return url;
    }

    @RequestMapping(value={"/listuser"})
    @ResponseBody
    public PageInfo<UserInfo> listuser(@RequestParam(required=true, defaultValue="1") Integer page, @RequestParam(required=true, defaultValue="5") Integer pageSize, @RequestParam(required=true) Integer type, HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return null;
        }
        PageHelper.startPage((int)page, (int)pageSize);
        List list = null;
        if (user.getRole() == 1 || user.getRole() == 0) {
            list = this.userService.selectUserList(type.intValue());
        } else if (user.getRole() == 2) {
            list = this.userService.selectUserList(user.getCollege(), type.intValue());
        }
        if (list == null) {
            return null;
        }
        PageInfo p = new PageInfo(list);
        return p;
    }

    @RequestMapping(value={"/edituser"})
    @ResponseBody
    public Integer edituser(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String uName = request.getParameter("uName");
        String email = request.getParameter("email");
        String tel = request.getParameter("tel");
        String jobTitle = request.getParameter("jobTitle");
        String major = request.getParameter("major");
        String college = request.getParameter("college");
        UserInfo usernew = null;
        if (StringUtils.isNotNullString((String[])new String[]{uName, email})) {
            if (!email.equals(user.getEmail()) && (usernew = this.userService.selectUserByEmail(email)) != null) {
                return 2;
            }
            if (!uName.equals(user.getuName()) && (usernew = this.userService.selectUserByUsename(uName)) != null) {
                return 3;
            }
        }
        if (StringUtils.isNotNullString((String[])new String[]{uName, email, tel, jobTitle, major, college})) {
            usernew = new UserInfo();
            usernew.setuId(user.getuId());
            usernew.setuName(uName);
            usernew.setTel(tel);
            usernew.setEmail(email);
            usernew.setJobTitle(jobTitle);
            usernew.setMajor(major);
            usernew.setCollege(college);
            return this.userService.updateUserById(user);
        }
        if (StringUtils.isNotNullString((String[])new String[]{uName, email, tel, major, college})) {
            usernew = new UserInfo();
            usernew.setuId(user.getuId());
            usernew.setuName(uName);
            usernew.setTel(tel);
            usernew.setEmail(email);
            usernew.setMajor(major);
            usernew.setCollege(college);
            return this.userService.updateUserById(user);
        }
        if (StringUtils.isNotNullString((String[])new String[]{uName, email, tel})) {
            usernew = new UserInfo();
            usernew.setuId(user.getuId());
            usernew.setuName(uName);
            usernew.setTel(tel);
            usernew.setEmail(email);
            return this.userService.updateUserById(user);
        }
        return 0;
    }

    @RequestMapping(value={"/manageredituser"})
    @ResponseBody
    public Integer manageredituser(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String uId = request.getParameter("uId");
        String uName = request.getParameter("uName");
        String uRealname = request.getParameter("uRealname");
        String email = request.getParameter("email");
        String uCode = request.getParameter("uCode");
        String admissionDate = request.getParameter("admissionDate");
        String tel = request.getParameter("tel");
        String jobTitle = request.getParameter("jobTitle");
        String major = request.getParameter("major");
        String college = request.getParameter("college");
        String gender = request.getParameter("sex");
        String type = request.getParameter("type");
        UserInfo usernew = new UserInfo();
        if (admissionDate != null) {
            usernew.setAdmissionDate(StringUtils.strToDate((String)admissionDate, (String)"yyyy-MM-dd"));
        }
        usernew.setuName(uName);
        usernew.setuRealname(uRealname);
        usernew.setTel(tel);
        usernew.setEmail(email);
        usernew.setJobTitle(jobTitle);
        usernew.setMajor(major);
        usernew.setCollege(college);
        usernew.setuCode(uCode);
        try {
            usernew.setGender(Integer.valueOf(Integer.parseInt(gender)));
        }
        catch (Exception e) {
            return -1;
        }
        if (StringUtils.isNotNullString((String[])new String[]{uName, email, uCode})) {
            UserInfo otheruser = null;
            otheruser = this.userService.selectUserByEmail(email);
            if (otheruser != null) {
                return -2;
            }
            otheruser = this.userService.selectUserByUsename(uName);
            if (otheruser != null) {
                return -3;
            }
            otheruser = this.userService.selectUserByuCode(uCode);
            if (otheruser != null) {
                return -4;
            }
        }
        if (uId == null) {
            if (type.equals("5")) {
                usernew.setRole(Integer.valueOf(5));
            } else if (type.equals("4")) {
                usernew.setRole(Integer.valueOf(4));
            } else if (type.equals("3")) {
                usernew.setRole(Integer.valueOf(3));
            } else if (type.equals("2")) {
                usernew.setRole(Integer.valueOf(2));
            } else if (type.equals("1")) {
                usernew.setRole(Integer.valueOf(1));
            }
            usernew.setuPassword(MD5Utils.stringEncoder((String)"123456"));
            usernew.setStatus(Integer.valueOf(1));
            return this.userService.insertUserSelective(usernew);
        }
        try {
            usernew.setuId(Integer.valueOf(Integer.parseInt(uId)));
        }
        catch (Exception e) {
            return -1;
        }
        return this.userService.updateUserById(usernew);
    }

    @RequestMapping(value={"/deleteuser"})
    @ResponseBody
    public Integer deleteuser(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String uId = request.getParameter("uId");
        if (uId == null) {
            return 0;
        }
        try {
            List list = this.projectBaseService.findprojectuserbyuser(Integer.valueOf(Integer.parseInt(uId)));
            if (list != null && list.size() > 0) {
                return -2;
            }
            return this.userService.deleteUserById(Integer.parseInt(uId));
        }
        catch (Exception e) {
            return -1;
        }
    }

    @RequestMapping(value={"/activateuser"})
    @ResponseBody
    public Integer activateuser(HttpServletRequest request) {
        UserInfo user = (UserInfo)request.getSession().getAttribute("user");
        if (user == null) {
            return 0;
        }
        String uId = request.getParameter("uId");
        if (uId == null) {
            return 0;
        }
        try {
            return this.userService.updateUserStatusById(Integer.valueOf(Integer.parseInt(uId)), Integer.valueOf(1));
        }
        catch (Exception e) {
            return -1;
        }
    }

    @RequestMapping(value={"/userinfo"})
    @ResponseBody
    public UserInfo userinfo(@RequestParam Integer uId, HttpServletRequest request) {
        UserInfo info = this.userService.selectUserById(uId.intValue());
        if (info == null) {
            return null;
        }
        return info;
    }
}

