/*
 * Decompiled with CFR 0.152.
 */
package com.plm.controller.file;

import com.plm.model.SiteFileInfo;
import com.plm.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class UploadController {
    @RequestMapping(value={"/upload"})
    public String upload(HttpServletRequest request, Model model) throws ServletException, IOException {
        String nexturl = "";
        String savePath = request.getServletContext().getRealPath("/WEB-INF/upload");
        String tempPath = request.getServletContext().getRealPath("/WEB-INF/temp");
        File tmpFile = new File(tempPath);
        if (!tmpFile.exists()) {
            tmpFile.mkdir();
        }
        String message = "";
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(102400);
            factory.setRepository(tmpFile);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setProgressListener((ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
            upload.setHeaderEncoding("UTF-8");
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                return nexturl;
            }
            upload.setFileSizeMax(0x6400000L);
            upload.setSizeMax(1048576000L);
            List list = upload.parseRequest(request);
            for (FileItem item : list) {
                if (item.isFormField()) {
                    String name = item.getFieldName();
                    String value = item.getString("UTF-8");
                    request.setAttribute(name, (Object)value);
                } else {
                    int extName;
                    long fileSize = item.getSize();
                    fileSize /= 1024L;
                    String filename = item.getName();
                    if (filename == null || filename.trim().equals("")) continue;
                    String fileExtName = (filename = filename.substring(filename.lastIndexOf("\\") + 1)).substring(filename.lastIndexOf(".") + 1);
                    if (fileExtName.equalsIgnoreCase("doc") || fileExtName.equalsIgnoreCase("docx")) {
                        extName = 0;
                    } else if (fileExtName.equalsIgnoreCase("xls") || fileExtName.equalsIgnoreCase("xlsx")) {
                        extName = 1;
                    } else if (fileExtName.equalsIgnoreCase("pdf")) {
                        extName = 2;
                    } else if (fileExtName.equalsIgnoreCase("zip") || fileExtName.equalsIgnoreCase("7z") || fileExtName.equalsIgnoreCase("rar")) {
                        extName = 3;
                    } else {
                        message = "\u683c\u5f0f\u9519\u8bef";
                        model.addAttribute("info", (Object)message);
                        return "info";
                    }
                    InputStream in = item.getInputStream();
                    String saveFilename = this.makeFileName(filename);
                    String realSavePath = this.makePath(saveFilename, savePath);
                    FileOutputStream out = new FileOutputStream(realSavePath + "\\" + saveFilename);
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    in.close();
                    out.close();
                    item.delete();
                    message = "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01";
                    SiteFileInfo sitefile = new SiteFileInfo();
                    String sfFrom = (String)request.getAttribute("sfFrom");
                    String relatedId = (String)request.getAttribute("relatedId");
                    String sfBrief = (String)request.getAttribute("sfBrief");
                    if (sfFrom != null) {
                        sitefile.setSfFrom(Integer.valueOf(Integer.parseInt(sfFrom)));
                    }
                    if (relatedId != null) {
                        sitefile.setRelatedId(Integer.valueOf(Integer.parseInt(relatedId)));
                    }
                    sitefile.setSfBrief(sfBrief);
                    sitefile.setSfType(Integer.valueOf(extName));
                    sitefile.setSfName(saveFilename);
                    sitefile.setSfSize(Integer.valueOf((int)fileSize));
                    sitefile.setSfPath(realSavePath);
                    sitefile.setUpTime(StringUtils.getDate());
                    model.addAttribute("sitefile", (Object)sitefile);
                    request.setAttribute("sitefile", (Object)sitefile);
                    request.setAttribute("info", (Object)"\u6210\u529f");
                }
                nexturl = (String)request.getAttribute("nexturl");
            }
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            e.printStackTrace();
            message = "\u5355\u4e2a\u6587\u4ef6\u8d85\u51fa\u6700\u5927\u503c\uff01\uff01\uff01";
            model.addAttribute("info", (Object)message);
            request.setAttribute("info", (Object)message);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            e.printStackTrace();
            message = "\u4e0a\u4f20\u6587\u4ef6\u7684\u603b\u7684\u5927\u5c0f\u8d85\u51fa\u9650\u5236\u7684\u6700\u5927\u503c\uff01\uff01\uff01";
            model.addAttribute("info", (Object)message);
            request.setAttribute("info", (Object)message);
        }
        catch (Exception e) {
            message = "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01";
            model.addAttribute("info", (Object)message);
            request.setAttribute("info", (Object)message);
            e.printStackTrace();
        }
        model.addAttribute("info", (Object)message);
        request.setAttribute("info", (Object)message);
        return "forward:" + nexturl;
    }

    private String makeFileName(String filename) {
        return UUID.randomUUID().toString() + "_" + filename;
    }

    private String makePath(String filename, String savePath) {
        System.out.println("\u4f20\u5165\u7684\u6587\u4ef6\u540d" + filename);
        int hashcode = filename.hashCode();
        System.out.println(hashcode);
        int dir1 = hashcode & 0xF;
        int dir2 = (hashcode & 0xF0) >> 4;
        String dir = savePath + "\\" + dir1 + "\\" + dir2;
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dir;
    }
}

