/*
 * Decompiled with CFR 0.152.
 */
package com.plm.service.impl;

import com.plm.dao.ProjectBaseViewMapper;
import com.plm.dao.ProjectPlanMapper;
import com.plm.model.ProjectBaseView;
import com.plm.model.ProjectBaseViewExample;
import com.plm.model.ProjectPlan;
import com.plm.model.ProjectPlanExample;
import com.plm.model.ProjectPlanView;
import com.plm.model.UserInfo;
import com.plm.service.IProjectPlanService;
import com.plm.util.IMailService;
import com.plm.util.MailEntry;
import com.plm.util.StringUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="projectPlanService")
public class ProjectPlanServiceImpl
implements IProjectPlanService {
    @Resource
    private ProjectPlanMapper ppDao;
    private ProjectPlanExample ppEX;
    @Resource
    private ProjectBaseViewMapper pbviewDao;
    private ProjectBaseViewExample pbViewEx;
    @Resource
    private IMailService mailService;

    public int addProjectPlan(ProjectPlan plan) {
        return this.ppDao.insertSelective(plan);
    }

    public int deleteProjectPlan(int planId) {
        this.pbViewEx = new ProjectBaseViewExample();
        this.pbViewEx.createCriteria().andPpIdEqualTo(Integer.valueOf(planId));
        List projectlist = this.pbviewDao.selectByExample(this.pbViewEx);
        if (projectlist != null) {
            for (ProjectBaseView project : projectlist) {
                if (project.getPbStatus() <= -1) continue;
                return 0;
            }
        }
        return this.ppDao.deleteByPrimaryKey(Integer.valueOf(planId));
    }

    public int editProjectPlan(ProjectPlan plan) {
        if (plan == null) {
            return 0;
        }
        int flag = 0;
        ProjectPlan oldplan = this.ppDao.selectByPrimaryKey(plan.getPpId());
        flag = this.ppDao.updateByPrimaryKeySelective(plan);
        if (flag == 1) {
            this.pbViewEx = new ProjectBaseViewExample();
            this.pbViewEx.createCriteria().andPpIdEqualTo(plan.getPpId());
            List projectlist = this.pbviewDao.selectByExample(this.pbViewEx);
            if (projectlist != null) {
                String[] addr;
                if (plan.getPpStartTime().getTime() != oldplan.getPpStartTime().getTime()) {
                    MailEntry startmail = new MailEntry();
                    startmail.setSubject("\u9879\u76ee\u7acb\u9879\u65f6\u95f4\u53d8\u66f4\u901a\u77e5");
                    for (ProjectBaseView project : projectlist) {
                        try {
                            addr = new String[]{project.getEmail()};
                            startmail.setRecipients(addr);
                            startmail.setText("\u300a" + project.getPbName() + "\u300b\u9879\u76ee\u7acb\u9879\u65f6\u95f4\u53d8\u66f4\u4e3a\uff1a" + StringUtils.dateToStr((Date)plan.getPpStartTime(), (String)"yyyy-MM-dd"));
                            this.mailService.sendMail(startmail);
                        }
                        catch (Exception e) {
                            return 2;
                        }
                    }
                }
                if (plan.getPpMidTime().getTime() != oldplan.getPpMidTime().getTime()) {
                    MailEntry midmail = new MailEntry();
                    midmail.setSubject("\u9879\u76ee\u4e2d\u671f\u68c0\u67e5\u65f6\u95f4\u53d8\u66f4\u901a\u77e5");
                    for (ProjectBaseView project : projectlist) {
                        try {
                            addr = new String[]{project.getEmail()};
                            midmail.setRecipients(addr);
                            midmail.setText("\u300a" + project.getPbName() + "\u300b\u9879\u76ee\u4e2d\u671f\u68c0\u67e5\u53d8\u66f4\u4e3a\uff1a" + StringUtils.dateToStr((Date)plan.getPpMidTime(), (String)"yyyy-MM-dd"));
                            this.mailService.sendMail(midmail);
                        }
                        catch (Exception e) {
                            return 2;
                        }
                    }
                }
                if (plan.getPpEndTime().getTime() != oldplan.getPpEndTime().getTime()) {
                    MailEntry endmail = new MailEntry();
                    endmail.setSubject("\u9879\u76ee\u9a8c\u6536\u65f6\u95f4\u53d8\u66f4\u901a\u77e5");
                    for (ProjectBaseView project : projectlist) {
                        try {
                            addr = new String[]{project.getEmail()};
                            endmail.setRecipients(addr);
                            endmail.setText("\u300a" + project.getPbName() + "\u300b\u9879\u76ee\u9a8c\u6536\u65f6\u95f4\u53d8\u66f4\u4e3a\uff1a" + StringUtils.dateToStr((Date)plan.getPpEndTime(), (String)"yyyy-MM-dd"));
                            this.mailService.sendMail(endmail);
                        }
                        catch (Exception e) {
                            return 2;
                        }
                    }
                }
            }
        }
        return flag;
    }

    public ProjectPlan findProjectPlan(int planId) {
        ProjectPlan pplan = this.ppDao.selectByPrimaryKey(Integer.valueOf(planId));
        if (pplan != null) {
            return pplan;
        }
        return null;
    }

    public List<ProjectPlanView> findProjectView(int planId) {
        return null;
    }

    public List<ProjectPlanView> findProject(int planId) {
        return null;
    }

    public List<ProjectPlan> findProjectPlanAll() {
        this.ppEX = new ProjectPlanExample();
        this.ppEX.createCriteria().andPpIdIsNotNull();
        List list = this.ppDao.selectByExample(this.ppEX);
        if (list != null && list.size() > 0) {
            return list;
        }
        return null;
    }

    public List<ProjectPlan> findProjectPlanByUser(UserInfo user) {
        this.ppEX = new ProjectPlanExample();
        this.ppEX.createCriteria().andAcceptTimeLessThanOrEqualTo(user.getAdmissionDate()).andPpYearEqualTo(StringUtils.getSysYear());
        List list = this.ppDao.selectByExample(this.ppEX);
        if (list != null && list.size() > 0) {
            return list;
        }
        return null;
    }
}

