/*
 * Decompiled with CFR 0.152.
 */
package com.plm.util;

import com.plm.util.StringUtils;
import java.util.Arrays;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.Assert;

public class MailEntry {
    private String[] recipients;
    private String[] carbonCopy;
    private String subject;
    private String text;

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String[] getRecipients() {
        return (String[])this.recipients.clone();
    }

    public void setRecipients(String[] recipients) throws AddressException {
        Assert.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])recipients), (String)"\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        String[] addresses = new String[recipients.length];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = recipients[i];
        }
        this.recipients = addresses;
    }

    public String[] getCarbonCopy() {
        if (ArrayUtils.isNotEmpty((Object[])this.carbonCopy)) {
            return (String[])this.carbonCopy.clone();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void setCarbonCopy(String[] carbonCopy) throws AddressException {
        String[] addresses = new String[carbonCopy.length];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = this.parseAddress(carbonCopy[i]);
        }
        this.carbonCopy = addresses;
    }

    private String parseAddress(String recipient) throws AddressException {
        if (!StringUtils.isNotNullString((String[])new String[]{recipient})) {
            throw new AddressException("\u90ae\u7bb1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", recipient);
        }
        return recipient + "@company.com";
    }

    public String toString() {
        return "MailEntry{recipients=" + Arrays.toString(this.recipients) + ", carbonCopy=" + Arrays.toString(this.carbonCopy) + ", subject='" + this.subject + '\'' + ", text='" + this.text + '\'' + '}';
    }
}

