/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.task;

import com.alibaba.fastjson.JSON;
import com.github.yeecode.objectLogger.client.annotation.LogDescription;
import com.github.yeecode.objectLogger.client.bean.HttpBean;
import com.github.yeecode.objectLogger.client.bean.LocalTypeHandler;
import com.github.yeecode.objectLogger.client.bean.ObjectLoggerConfigBean;
import com.github.yeecode.objectLogger.client.constant.AttributeTypeEnum;
import com.github.yeecode.objectLogger.client.model.ActionItemModel;
import com.github.yeecode.objectLogger.client.model.ActionModel;
import java.lang.reflect.Field;
import java.util.Date;
import org.springframework.util.CollectionUtils;

public class SendLogForObjectTask
implements Runnable {
    private LocalTypeHandler localTypeHandler;
    private Integer objectId;
    private String actor;
    private String action;
    private String actionName;
    private String extraWords;
    private String comment;
    private Object oldObject;
    private Object newObject;
    private ObjectLoggerConfigBean objectLoggerConfigBean;
    private HttpBean httpBean;

    public SendLogForObjectTask(Integer objectId, String actor, String action, String actionName, String extraWords, String comment, Object oldObject, Object newObject, ObjectLoggerConfigBean objectLoggerConfigBean, HttpBean httpBean, LocalTypeHandler localTypeHandler) {
        this.objectId = objectId;
        this.actor = actor;
        this.action = action;
        this.actionName = actionName;
        this.extraWords = extraWords;
        this.comment = comment;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.objectLoggerConfigBean = objectLoggerConfigBean;
        this.httpBean = httpBean;
        this.localTypeHandler = localTypeHandler;
    }

    @Override
    public void run() {
        try {
            ActionModel actionModel = new ActionModel(this.objectLoggerConfigBean.getAppName(), this.oldObject.getClass().getSimpleName(), this.objectId, this.actor, this.action, this.actionName, this.extraWords, this.comment, new Date());
            Class<?> modelClazz = this.newObject.getClass();
            Class<?> oldModelClazz = this.oldObject.getClass();
            if (oldModelClazz.equals(modelClazz)) {
                Field[] fields;
                for (Field field : fields = modelClazz.getDeclaredFields()) {
                    String newValue;
                    LogDescription logDescription = field.getAnnotation(LogDescription.class);
                    if (logDescription == null) continue;
                    field.setAccessible(true);
                    String oldValue = field.get(this.oldObject) != null ? JSON.toJSONString((Object)field.get(this.oldObject)) : JSON.toJSONString((Object)"");
                    String string = newValue = field.get(this.newObject) != null ? JSON.toJSONString((Object)field.get(this.newObject)) : JSON.toJSONString((Object)"");
                    if (oldValue.equals(newValue)) continue;
                    ActionItemModel actionItemModel = new ActionItemModel();
                    String attribute = field.getName();
                    actionItemModel.setAttribute(attribute);
                    actionItemModel.setAttributeName(logDescription.name().length() == 0 ? attribute : logDescription.name());
                    ActionItemModel handlerOutput = logDescription.type().handler(this.localTypeHandler, logDescription.localType(), oldValue, newValue);
                    if (handlerOutput == null) continue;
                    actionItemModel.setOldValue(handlerOutput.getOldValue());
                    actionItemModel.setNewValue(handlerOutput.getNewValue());
                    actionItemModel.setDiffValue(handlerOutput.getDiffValue());
                    actionItemModel.setAttributeType(logDescription.type().equals((Object)AttributeTypeEnum.LOCALTYPE) ? logDescription.localType() : logDescription.type().name());
                    actionModel.getActionItemModelList().add(actionItemModel);
                }
            }
            if (!CollectionUtils.isEmpty(actionModel.getActionItemModelList())) {
                this.httpBean.sendLog(JSON.toJSONString((Object)actionModel));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

