/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.richText;

import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class Html2Text
extends HTMLEditorKit.ParserCallback {
    private String lineBreak = "\n";
    private StringBuilder stringBuilder = new StringBuilder();

    public static String simpleHtml(String html) {
        try {
            if (html.isEmpty()) {
                return "";
            }
            Html2Text parser = new Html2Text();
            parser.parse(html);
            return parser.getText() != null ? parser.getText() : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void parse(String html) throws IOException {
        StringReader reader = new StringReader(html);
        ParserDelegator parsers = new ParserDelegator();
        parsers.parse(reader, this, Boolean.TRUE);
    }

    @Override
    public void handleText(char[] text, int pos) {
        this.stringBuilder.append(text);
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (this.stringBuilder.length() != 0 && t.isBlock() && !this.stringBuilder.toString().endsWith(this.lineBreak)) {
            this.stringBuilder.append(this.lineBreak);
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        if (this.stringBuilder.length() != 0 && t.isBlock() && !this.stringBuilder.toString().endsWith(this.lineBreak)) {
            this.stringBuilder.append(this.lineBreak);
        }
    }

    @Override
    public void handleEndOfLineString(String eol) {
        if (this.stringBuilder.length() - this.lineBreak.length() > 0) {
            this.stringBuilder.delete(this.stringBuilder.length() - this.lineBreak.length(), this.stringBuilder.length());
        }
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (HTML.Tag.IMG.equals(t)) {
            this.stringBuilder.append("\u3010\u3010-START_IMG-\u3011\u3011 " + a.toString() + "\u3010\u3010-END_IMG-\u3011\u3011");
        }
    }

    public String getText() {
        return this.stringBuilder.toString();
    }
}

