/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.task;

import com.alibaba.fastjson.JSON;
import com.github.yeecode.objectLogger.client.config.ObjectLoggerConfigBean;
import com.github.yeecode.objectLogger.client.handler.BaseExtendedTypeHandler;
import com.github.yeecode.objectLogger.client.handler.BuiltinTypeHandler;
import com.github.yeecode.objectLogger.client.http.HttpBean;
import com.github.yeecode.objectLogger.client.model.ActionModel;
import com.github.yeecode.objectLogger.client.model.BaseActionItemModel;
import com.github.yeecode.objectLogger.client.wrapper.ClazzWrapper;
import com.github.yeecode.objectLogger.client.wrapper.FieldWrapper;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class SendLogForObjectTask
implements Runnable {
    private BaseExtendedTypeHandler baseExtendedTypeHandler;
    private Integer objectId;
    private String actor;
    private String action;
    private String actionName;
    private String extraWords;
    private String comment;
    private Object oldObject;
    private Object newObject;
    private ObjectLoggerConfigBean objectLoggerConfigBean;
    private HttpBean httpBean;

    public SendLogForObjectTask(Integer objectId, String actor, String action, String actionName, String extraWords, String comment, Object oldObject, Object newObject, ObjectLoggerConfigBean objectLoggerConfigBean, HttpBean httpBean, BaseExtendedTypeHandler baseExtendedTypeHandler) {
        this.objectId = objectId;
        this.actor = actor;
        this.action = action;
        this.actionName = actionName;
        this.extraWords = extraWords;
        this.comment = comment;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.objectLoggerConfigBean = objectLoggerConfigBean;
        this.httpBean = httpBean;
        this.baseExtendedTypeHandler = baseExtendedTypeHandler;
    }

    @Override
    public void run() {
        try {
            ActionModel actionModel = new ActionModel(this.objectLoggerConfigBean.getAppName(), this.oldObject.getClass().getSimpleName(), this.objectId, this.actor, this.action, this.actionName, this.extraWords, this.comment, new Date());
            Class<?> modelClazz = this.newObject.getClass();
            Class<?> oldModelClazz = this.oldObject.getClass();
            if (oldModelClazz.equals(modelClazz)) {
                ClazzWrapper clazzWrapper = new ClazzWrapper(modelClazz);
                List<Field> fieldList = clazzWrapper.getFieldList();
                for (Field field : fieldList) {
                    BaseActionItemModel baseActionItemModel;
                    field.setAccessible(true);
                    FieldWrapper fieldWrapper = new FieldWrapper(field, field.get(this.oldObject), field.get(this.newObject));
                    if (!fieldWrapper.isWithLogTag() && !"true".equals(this.objectLoggerConfigBean.getAutoLog()) || this.nullableEquals(fieldWrapper.getOldValue(), fieldWrapper.getNewValue()) || (baseActionItemModel = fieldWrapper.isWithExtendedType() ? this.handleExtendedTypeItem(fieldWrapper) : this.handleBuiltinTypeItem(fieldWrapper)) == null) continue;
                    actionModel.addBaseActionItemModel(baseActionItemModel);
                }
            }
            if (!CollectionUtils.isEmpty(actionModel.getActionItemModelList())) {
                this.httpBean.sendLog(JSON.toJSONString((Object)actionModel));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private BaseActionItemModel handleBuiltinTypeItem(FieldWrapper fieldWrapper) {
        BaseActionItemModel handlerOutput;
        BuiltinTypeHandler builtinType = BuiltinTypeHandler.NORMAL;
        if (fieldWrapper.getLogTag() != null) {
            builtinType = fieldWrapper.getLogTag().builtinType();
        }
        if ((handlerOutput = builtinType.handlerAttributeChange(fieldWrapper)) != null) {
            handlerOutput.setAttribute(fieldWrapper.getAttributeName());
            handlerOutput.setAttributeName(fieldWrapper.getDisplayName());
            handlerOutput.setAttributeType(builtinType.name());
            return handlerOutput;
        }
        return null;
    }

    private BaseActionItemModel handleExtendedTypeItem(FieldWrapper fieldWrapper) {
        BaseActionItemModel baseActionItemModel = this.baseExtendedTypeHandler.handleAttributeChange(fieldWrapper.getExtendedType(), fieldWrapper.getAttributeName(), fieldWrapper.getLogTagName(), fieldWrapper.getOldValue(), fieldWrapper.getNewValue());
        if (baseActionItemModel.getAttributeType() == null) {
            baseActionItemModel.setAttributeType(fieldWrapper.getExtendedType());
        }
        if (baseActionItemModel.getAttribute() == null) {
            baseActionItemModel.setAttribute(fieldWrapper.getAttributeName());
        }
        if (baseActionItemModel.getAttributeName() == null) {
            baseActionItemModel.setAttributeName(fieldWrapper.getDisplayName());
        }
        return baseActionItemModel;
    }

    private boolean nullableEquals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }
}

