/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.http;

import com.github.yeecode.objectLogger.client.config.ObjectLoggerConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpUtil {
    private static final Log LOGGER = LogFactory.getLog(HttpUtil.class);
    @Autowired(required=false)
    private ObjectLoggerConfig objectLoggerConfig;

    public synchronized void sendLog(String jsonString) {
        try {
            ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>();
            paramsList.add((NameValuePair)new BasicNameValuePair("logJsonString", jsonString));
            this.sendPost(this.objectLoggerConfig.getServerAddress() + "/ObjectLogger/log/add", paramsList);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"sendLog error!", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String sendPost(String url, List<NameValuePair> nameValuePairList) throws Exception {
        try (CloseableHttpResponse response = null;
             CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost post = new HttpPost(url);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairList, "UTF-8");
            post.setEntity((HttpEntity)entity);
            post.setHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
            post.setHeader((Header)new BasicHeader("Accept", "text/plain;charset=utf-8"));
            response = client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                return string;
            }
        }
        return null;
    }
}

