/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.task;

import com.alibaba.fastjson.JSON;
import com.github.yeecode.objectLogger.client.config.ObjectLoggerConfig;
import com.github.yeecode.objectLogger.client.http.HttpUtil;
import com.github.yeecode.objectLogger.client.model.BaseAttributeModel;
import com.github.yeecode.objectLogger.client.model.OperationModel;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class LogAttributesTask
implements Runnable {
    private HttpUtil httpUtil;
    private String objectName;
    private Integer objectId;
    private String operator;
    private String operationName;
    private String operationAlias;
    private String extraWords;
    private String comment;
    private ObjectLoggerConfig objectLoggerConfig;
    private List<BaseAttributeModel> baseAttributeModelList;

    public LogAttributesTask(String objectName, Integer objectId, String operator, String operationName, String operationAlias, String extraWords, String comment, List<BaseAttributeModel> baseAttributeModelList, ObjectLoggerConfig objectLoggerConfig, HttpUtil httpUtil) {
        this.objectName = objectName;
        this.objectId = objectId;
        this.operator = operator;
        this.operationName = operationName;
        this.operationAlias = operationAlias;
        this.extraWords = extraWords;
        this.comment = comment;
        this.baseAttributeModelList = baseAttributeModelList;
        this.objectLoggerConfig = objectLoggerConfig;
        this.httpUtil = httpUtil;
    }

    @Override
    public void run() {
        try {
            OperationModel operationModel = new OperationModel(this.objectLoggerConfig.getBusinessAppName(), this.objectName, this.objectId, this.operator, this.operationName, this.operationAlias, this.extraWords, this.comment, new Date());
            if (!CollectionUtils.isEmpty(this.baseAttributeModelList)) {
                operationModel.addBaseActionItemModelList(this.baseAttributeModelList);
            }
            this.httpUtil.sendLog(JSON.toJSONString((Object)operationModel));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

