/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectlogger.client.task;

import com.github.yeecode.objectlogger.client.config.ObjectLoggerConfig;
import com.github.yeecode.objectlogger.client.http.HttpUtil;
import com.github.yeecode.objectlogger.client.model.BaseAttributeModel;
import com.github.yeecode.objectlogger.client.model.OperationModel;
import com.google.gson.Gson;
import java.util.Date;
import java.util.List;

public class LogAttributesTask
implements Runnable {
    private HttpUtil httpUtil;
    private String objectName;
    private String objectId;
    private String operator;
    private String operationName;
    private String operationAlias;
    private String extraWords;
    private String comment;
    private ObjectLoggerConfig objectLoggerConfig;
    private List<BaseAttributeModel> baseAttributeModelList;

    public LogAttributesTask(String objectName, String objectId, String operator, String operationName, String operationAlias, String extraWords, String comment, List<BaseAttributeModel> baseAttributeModelList, ObjectLoggerConfig objectLoggerConfig, HttpUtil httpUtil) {
        this.objectName = objectName;
        this.objectId = objectId;
        this.operator = operator;
        this.operationName = operationName;
        this.operationAlias = operationAlias;
        this.extraWords = extraWords;
        this.comment = comment;
        this.baseAttributeModelList = baseAttributeModelList;
        this.objectLoggerConfig = objectLoggerConfig;
        this.httpUtil = httpUtil;
    }

    @Override
    public void run() {
        try {
            OperationModel operationModel = new OperationModel(this.objectLoggerConfig.getBusinessAppName(), this.objectName, this.objectId, this.operator, this.operationName, this.operationAlias, this.extraWords, this.comment, new Date());
            if (this.baseAttributeModelList != null && !this.baseAttributeModelList.isEmpty()) {
                operationModel.addBaseActionItemModelList(this.baseAttributeModelList);
            }
            this.httpUtil.sendLog(new Gson().toJson((Object)operationModel));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

