package com.github.yin.cli.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotates class and fields with flag descriptions, seen in e.g. usage help. If supplied,
 * {@link Usage#name()} is used to determine flag name, otherwise field name of the
 * annotated field is used.
 *
 * For classpath-scanning to work correctly, each class having a @Usage member must be
 * itself annotated with @Usage.
 *
 * <pre>{@code
 * @Usage("This class uses java-cli")
 * public class TestUsage {
 *     @Usage("This is a java-flag accessor")
 *     private static final Flag<String> inputFileFlag = Cli.string("inputFile");
 * }
 * }</pre>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD, ElementType.TYPE})
public @interface Usage {
    /** Name of flag. */
    String name() default "";
    /** Flag description. */
    String value();
}
