/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.cli;

import com.github.yin.cli.ArgumentProvider;
import com.github.yin.cli.ClassMetadataIndex;
import com.github.yin.cli.Flag;
import com.github.yin.cli.FlagID;
import com.github.yin.cli.FlagIndex;
import com.github.yin.cli.FlagMetadata;
import com.github.yin.cli.TypeConversions;
import com.github.yin.cli.TypeConversionsImpl;
import com.github.yin.cli.analysis.UsagePrinter;
import com.github.yin.cli.annotations.ClassScanner;
import com.github.yin.cli.parsing.LongKeyValueParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.UnmodifiableIterator;

public class Cli
implements ArgumentProvider {
    private static Cli instance;
    private final ClassScanner classScanner;
    private final ClassMetadataIndex classMetadataIndex;
    private final FlagIndex<Flag<?>> flagIndex;
    private final FlagIndex<FlagMetadata> flagMetadataIndex;
    private ImmutableMultimap<String, String> flagValues;
    private final TypeConversions typeConversions;

    public static void init(String[] args) throws IllegalStateException {
        Cli.init(new LongKeyValueParser(args).parse());
    }

    public static void init(ImmutableMultimap<String, String> args) throws IllegalStateException {
        if (Cli.instance().flagValues != null) {
            throw new IllegalStateException("Cli cli already has been already initialized.");
        }
        Cli.instance().setArguments(args);
    }

    public static Flag<String> string(String name) {
        return Cli.create(String.class, name);
    }

    public static <T> Flag<T> create(Class<T> type, String name) {
        return Cli.instance().createFlag(type, name);
    }

    private <T> Flag<T> createFlag(Class<T> type, String name) {
        try {
            String callerClass = this.scanCallerClass();
            FlagID id = FlagID.create(callerClass, name);
            Flag flag = Flag.create(id, type, this, this.typeConversions);
            this.flagIndex.add(id, flag);
            return flag;
        }
        catch (ClassNotFoundException ex) {
            Throwables.propagate((Throwable)ex);
            return null;
        }
    }

    public static void printUsage(String packagePrefix) {
        Cli.instance().printUsageForPackage(packagePrefix);
    }

    @VisibleForTesting
    static ClassMetadataIndex classMetadata() {
        return Cli.instance().classMetadataIndex;
    }

    @VisibleForTesting
    static FlagIndex flagMetadata() {
        return Cli.instance().flagMetadataIndex;
    }

    @VisibleForTesting
    void setArguments(ImmutableMultimap<String, String> args) {
        this.flagValues = args;
    }

    public static void clear() {
        Cli.instance().clearArguments();
    }

    public TypeConversions getTypeConversions() {
        return this.typeConversions;
    }

    private void clearArguments() {
        this.flagValues = null;
    }

    @Override
    public String singleArgument(FlagID flagID) {
        UnmodifiableIterator iter;
        ImmutableCollection<String> ret = this.allArguments(flagID);
        if (ret != null && (iter = ret.iterator()).hasNext()) {
            return (String)iter.next();
        }
        return null;
    }

    @Override
    public ImmutableCollection<String> allArguments(FlagID flagID) {
        ImmutableCollection ret = this.flagValues.get((Object)(flagID.className() + '.' + flagID.flagName()));
        if (ret == null || ret.isEmpty()) {
            ret = this.flagValues.get((Object)flagID.flagName());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printUsageForPackage(String packagePrefix) {
        Cli cli = this;
        synchronized (cli) {
            this.classScanner.scanPackage(packagePrefix, this.flagMetadataIndex, this.classMetadataIndex);
        }
        new UsagePrinter().printUsage(this.flagMetadataIndex, this.classMetadataIndex, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private String scanCallerClass() throws ClassNotFoundException {
        String className = this.getCallerClassName();
        Cli cli = this;
        synchronized (cli) {
            this.classScanner.scanClass(className, this.flagMetadataIndex, this.classMetadataIndex);
        }
        return className;
    }

    private Cli(ClassScanner classScanner, ClassMetadataIndex classMetadataIndex, FlagIndex<Flag<?>> flagIndex, FlagIndex<FlagMetadata> flagMetadataIndex, TypeConversions typeConversions) {
        this.classScanner = classScanner;
        this.classMetadataIndex = classMetadataIndex;
        this.flagIndex = flagIndex;
        this.flagMetadataIndex = flagMetadataIndex;
        this.flagValues = null;
        this.typeConversions = typeConversions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cli instance() {
        Class<Cli> clazz = Cli.class;
        synchronized (Cli.class) {
            if (instance == null) {
                instance = Cli.createCli();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    static Cli createCli() {
        return Cli.createCli(new ClassScanner(), new ClassMetadataIndex(), new FlagIndex(), new FlagIndex<FlagMetadata>(), new TypeConversionsImpl());
    }

    @VisibleForTesting
    static Cli createCli(ClassScanner classScanner, ClassMetadataIndex classMetadataIndex, FlagIndex<Flag<?>> flagFlagIndex, FlagIndex<FlagMetadata> flagMetadataFlagIndex, TypeConversions typeConversion) {
        return new Cli(classScanner, classMetadataIndex, flagFlagIndex, flagMetadataFlagIndex, typeConversion);
    }

    private String getCallerClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String myType = Cli.class.getCanonicalName();
        String threadType = Thread.class.getCanonicalName();
        for (StackTraceElement e : stackTrace) {
            if (e.getClassName().equals(myType) || e.getClassName().equals(threadType)) continue;
            return e.getClassName();
        }
        return null;
    }
}

