/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.cli;

import com.github.yin.cli.FlagID;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;

public final class FlagIndex<T> {
    private final Multimap<String, T> byName = HashMultimap.create();
    private final Multimap<String, T> byClass = HashMultimap.create();
    private final Map<String, T> byFQN = Maps.newTreeMap();
    private ImmutableMultimap<String, T> _byName;
    private ImmutableMultimap<String, T> _byClass;
    private ImmutableMap<String, T> _byFQN;

    public void add(FlagID flagID, T flag) {
        String clazz = flagID.className();
        String name = flagID.flagName();
        String fqn = flagID.fqn();
        this.byName.put((Object)name, flag);
        this.byClass.put((Object)clazz, flag);
        this.byFQN.put(fqn, flag);
        this._byName = null;
        this._byClass = null;
        this._byFQN = null;
    }

    public Multimap<String, T> byName() {
        return this._byName != null ? this._byName : (this._byName = ImmutableMultimap.copyOf(this.byName));
    }

    public ImmutableMultimap<String, T> byClass() {
        return this._byClass != null ? this._byClass : (this._byClass = ImmutableMultimap.copyOf(this.byClass));
    }

    public Map<String, T> byFQN() {
        return this._byFQN != null ? this._byFQN : (this._byFQN = ImmutableMap.copyOf(this.byFQN));
    }
}

