/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.cli.analysis;

import com.github.yin.cli.ClassMetadataIndex;
import com.github.yin.cli.FlagIndex;
import com.github.yin.cli.FlagMetadata;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.TreeSet;

public class UsagePrinter {
    public void printUsage(FlagIndex<FlagMetadata> flagMetaIndex, ClassMetadataIndex classMetaIndex, PrintStream out) {
        ImmutableMultimap<String, FlagMetadata> links = flagMetaIndex.byClass();
        for (String className : links.keySet()) {
            String desc;
            TreeSet classFlags = Sets.newTreeSet((Iterable)links.get((Object)className));
            out.println(className + ':');
            if (classMetaIndex.classes().containsKey(className) && (desc = classMetaIndex.classes().get(className).desc()) != null && !desc.isEmpty()) {
                out.println(desc);
                out.println();
            }
            for (FlagMetadata link : classFlags) {
                out.println("\t" + link.flagID().flagName() + "\t" + link.desc());
            }
            out.println();
        }
    }
}

