/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.github.yin.flags.AutoValue_Flags_Error;
import com.github.yin.flags.AutoValue_Flags_FlagDesc;
import com.github.yin.flags.AutoValue_Flags_FlagID;
import com.github.yin.flags.Flag;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Flags {
    private static ArgumentIndex arguments;
    private static final FlagIndex flagIndex;
    private static final List<Error> errors;
    private static boolean collectErrors;

    public static boolean init(String[] args) {
        arguments = Flags.indexArguments(args);
        return arguments != null;
    }

    public static Flag<String> string(String name) {
        return Flags.create(String.class, name);
    }

    public static <T> Flag<T> create(Class<T> type, String name) {
        String callerClass = Flags.getCallerClassName();
        FlagID id = FlagID.create(callerClass, name);
        Flag flag = Flag.create(id, type, arguments);
        flagIndex.add(id, flag);
        return flag;
    }

    @VisibleForTesting
    public static void initForTesting(Map<String, String> options) {
        Flags.indexMap(options);
    }

    public static void enableErrorCollection(boolean collectErrors) {
        Flags.collectErrors = collectErrors;
    }

    public static ImmutableList<Error> getErrors() {
        return ImmutableList.copyOf(errors);
    }

    private static String getCallerClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String myType = Flags.class.getCanonicalName();
        String threadType = Thread.class.getCanonicalName();
        for (StackTraceElement e : stackTrace) {
            if (e.getClassName().equals(myType) || e.getClassName().equals(threadType)) continue;
            return e.getClassName();
        }
        return null;
    }

    private static ArgumentIndex indexArguments(String[] args) {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])args);
        ArgsAcceptor acceptor = new ArgsAcceptor();
        acceptor.startArgs();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.startsWith("--")) {
                acceptor.acceptKey(arg.substring(2));
                continue;
            }
            acceptor.acceptValue(arg);
        }
        acceptor.endArgs();
        return acceptor.buildIndex();
    }

    private static ArgumentIndex indexMap(Map<String, String> options) {
        ArgsAcceptor acceptor = new ArgsAcceptor();
        acceptor.startArgs();
        for (Map.Entry<String, String> option : options.entrySet()) {
            acceptor.acceptKey(option.getKey());
            acceptor.acceptValue(option.getValue());
        }
        acceptor.endArgs();
        return acceptor.buildIndex();
    }

    static void emitError(String message, Object ... args) {
        if (collectErrors) {
            errors.add(Error.create(message, args));
        }
    }

    static {
        flagIndex = new FlagIndex();
        errors = new ArrayList<Error>();
        collectErrors = false;
    }

    public static abstract class Error {
        public static Error create(String message, Object[] parameters) {
            return new AutoValue_Flags_Error(message, parameters);
        }

        public abstract String message();

        protected abstract Object varargs();

        public final Object[] parameters() {
            return (Object[])this.varargs();
        }

        public final String toString() {
            return String.format(this.message(), this.parameters());
        }
    }

    static class ArgumentIndex {
        private final ImmutableMultimap<String, String> argumentValues;

        public ArgumentIndex(ImmutableMultimap<String, String> argumentValues) {
            this.argumentValues = argumentValues;
        }

        public Collection<String> all(String className, String flagName) {
            ImmutableCollection ret = this.argumentValues.get((Object)(className + '.' + flagName));
            if (ret == null || ret.isEmpty()) {
                ret = this.argumentValues.get((Object)flagName);
            }
            return ret;
        }

        public String single(String className, String flagName) {
            Iterator<String> iter;
            Collection<String> ret = this.all(className, flagName);
            if (ret != null && (iter = ret.iterator()).hasNext()) {
                return iter.next();
            }
            return null;
        }
    }

    static class ArgsAcceptor {
        private AcceptorState state;
        private String _key;
        private final Multimap<String, String> arguments = ArrayListMultimap.create();

        ArgsAcceptor() {
        }

        void startArgs() {
            this.state = AcceptorState.KEY_EXPECTED;
        }

        void acceptKey(String key) {
            if (this.state != AcceptorState.KEY_EXPECTED) {
                Flags.emitError("Each option is a key-value pair, option " + this._key + " is followed directly by " + key, new Object[0]);
            }
            this._key = key;
            this.state = AcceptorState.VALUE_EXPECTED;
        }

        void acceptValue(String value) {
            if (this.state == AcceptorState.VALUE_EXPECTED) {
                this.arguments.put((Object)this._key, (Object)value);
                this.state = AcceptorState.KEY_EXPECTED;
            } else {
                Flags.emitError("Each option is a key value pair, key has been omitted before argument '" + value + "'", new Object[0]);
            }
        }

        void endArgs() {
            if (this.state != AcceptorState.KEY_EXPECTED) {
                Flags.emitError("Each option is a key-value pair, option " + this._key + " is the last arguments", new Object[0]);
            }
        }

        ArgumentIndex buildIndex() {
            return new ArgumentIndex((ImmutableMultimap<String, String>)ImmutableMultimap.copyOf(this.arguments));
        }

        static enum AcceptorState {
            KEY_EXPECTED,
            VALUE_EXPECTED;

        }
    }

    private static final class FlagIndex<T> {
        private final Multimap<String, T> byName = HashMultimap.create();
        private final Multimap<String, T> byClass = HashMultimap.create();
        private final Map<String, T> byFQN = Maps.newTreeMap();
        private ImmutableMultimap<String, T> _byName;
        private ImmutableMultimap<String, T> _byType;
        private ImmutableMap<String, T> _byFQN;

        private FlagIndex() {
        }

        public void add(FlagID flagID, T flag) {
            String clazz = flagID.className();
            String name = flagID.flagName();
            String fqn = flagID.fqn();
            this.byName.put((Object)name, flag);
            this.byClass.put((Object)clazz, flag);
            this.byFQN.put(fqn, flag);
            this._byName = null;
            this._byType = null;
            this._byFQN = null;
        }

        public Multimap<String, T> byName() {
            return this._byName != null ? this._byName : (this._byName = ImmutableMultimap.copyOf(this.byName));
        }

        public ImmutableMultimap<String, T> byType() {
            return this._byType != null ? this._byType : (this._byType = ImmutableMultimap.copyOf(this.byClass));
        }

        public Map<String, T> byFQN() {
            return this._byFQN != null ? this._byFQN : (this._byFQN = ImmutableMap.copyOf(this.byFQN));
        }
    }

    public static abstract class FlagDesc {
        static <T> FlagDesc create(String className, String flagName, String alt, String desc, Class<T> type) {
            return new AutoValue_Flags_FlagDesc(className, flagName, alt, desc, type);
        }

        abstract String className();

        abstract String flagName();

        @Nullable
        abstract String alt();

        @Nullable
        abstract String desc();

        abstract Class<?> type();

        final String fqn() {
            return this.className() + '.' + this.flagName();
        }
    }

    public static abstract class FlagID
    implements Comparable<FlagID> {
        static <T> FlagID create(String className, String flagName) {
            return new AutoValue_Flags_FlagID(className, flagName);
        }

        abstract String className();

        abstract String flagName();

        final String fqn() {
            return this.className() + '.' + this.flagName();
        }

        @Override
        public int compareTo(FlagID that) {
            return this.fqn().compareTo(that.fqn());
        }
    }
}

