/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.github.yin.flags.ArgumentProvider;
import com.github.yin.flags.AutoValue_Flag;
import com.github.yin.flags.FlagID;
import com.github.yin.flags.TypeConversion;

public abstract class Flag<T> {
    static <T> Flag create(FlagID flagID, Class<T> type, ArgumentProvider index, TypeConversion typeConversion) {
        return new AutoValue_Flag<T>(flagID, type, index, typeConversion);
    }

    abstract FlagID flagID();

    abstract Class<T> type();

    protected abstract ArgumentProvider flags();

    protected abstract TypeConversion typeConversion();

    public T get() {
        TypeConversion.Conversion<T> conversion = this.typeConversion().forType(this.type());
        if (conversion != null) {
            String value = this.flags().arguments().single(this.flagID());
            return conversion.apply(value);
        }
        throw new UnsupportedOperationException(String.format("Type conversion for Flag<%s>s is registered, Flag: %s", this.type().getCanonicalName(), this.flagID().toString()));
    }
}

