/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.answers;

import cdc.issues.answers.IssueResolution;
import cdc.issues.answers.IssueStatus;
import java.util.EnumSet;
import java.util.Set;

public enum IssueTransition {
    CONFIRM(EnumSet.of(IssueStatus.OPEN, IssueStatus.REOPENED, IssueStatus.RESOLVED, IssueStatus.WAITING), IssueStatus.CONFIRMED, IssueResolution.UNRESOLVED),
    WAIT(EnumSet.of(IssueStatus.CONFIRMED, IssueStatus.OPEN, IssueStatus.REOPENED, IssueStatus.RESOLVED), IssueStatus.WAITING, IssueResolution.UNRESOLVED),
    RESOLVE_AS_FIXED(EnumSet.of(IssueStatus.CONFIRMED, IssueStatus.OPEN, IssueStatus.REOPENED, IssueStatus.RESOLVED, IssueStatus.WAITING), IssueStatus.RESOLVED, IssueResolution.FIXED),
    RESOLVE_AS_WONT_FIX(EnumSet.of(IssueStatus.CONFIRMED, IssueStatus.OPEN, IssueStatus.REOPENED, IssueStatus.RESOLVED, IssueStatus.WAITING), IssueStatus.RESOLVED, IssueResolution.WONT_FIX),
    RESOLVE_AS_FALSE_POSITIVE(EnumSet.of(IssueStatus.CONFIRMED, IssueStatus.OPEN, IssueStatus.REOPENED, IssueStatus.RESOLVED, IssueStatus.WAITING), IssueStatus.RESOLVED, IssueResolution.FALSE_POSITIVE),
    REOPEN(EnumSet.of(IssueStatus.CLOSED, IssueStatus.RESOLVED), IssueStatus.REOPENED, IssueResolution.UNRESOLVED),
    OPEN(EnumSet.noneOf(IssueStatus.class), IssueStatus.OPEN, IssueResolution.UNRESOLVED),
    CLOSE_AS_FIXED(EnumSet.of(IssueStatus.CONFIRMED, IssueStatus.OPEN, IssueStatus.REOPENED, IssueStatus.RESOLVED, IssueStatus.WAITING), IssueStatus.CLOSED, IssueResolution.FIXED),
    CLOSE_AS_REMOVED(EnumSet.of(IssueStatus.CONFIRMED, IssueStatus.OPEN, IssueStatus.REOPENED, IssueStatus.RESOLVED, IssueStatus.WAITING), IssueStatus.CLOSED, IssueResolution.REMOVED),
    CLOSE_AS_WONT_FIX(EnumSet.of(IssueStatus.RESOLVED), IssueStatus.CLOSED, IssueResolution.WONT_FIX),
    CLOSE_AS_FALSE_POSITIVE(EnumSet.of(IssueStatus.RESOLVED), IssueStatus.CLOSED, IssueResolution.FALSE_POSITIVE);

    private final Set<IssueStatus> sourceStatuses;
    private final IssueStatus targetStatus;
    private final IssueResolution targetResolution;

    private IssueTransition(Set<IssueStatus> sourceStatues, IssueStatus targetStatus, IssueResolution targetResolution) {
        this.sourceStatuses = sourceStatues;
        this.targetResolution = targetResolution;
        this.targetStatus = targetStatus;
    }

    public boolean isManual() {
        return this == CONFIRM || this == REOPEN || this == RESOLVE_AS_FALSE_POSITIVE || this == RESOLVE_AS_FIXED || this == RESOLVE_AS_WONT_FIX || this == WAIT;
    }

    public boolean isAutomatic() {
        return this == CLOSE_AS_FALSE_POSITIVE || this == CLOSE_AS_FIXED || this == CLOSE_AS_REMOVED || this == CLOSE_AS_WONT_FIX || this == OPEN || this == REOPEN;
    }

    public boolean isValidSource(IssueStatus status, IssueResolution resolution) {
        if (status.isCompliantWith(resolution) && this.sourceStatuses.contains((Object)status)) {
            switch (this) {
                case RESOLVE_AS_FIXED: {
                    if (status == IssueStatus.RESOLVED) {
                        return resolution != IssueResolution.FIXED;
                    }
                    return true;
                }
                case RESOLVE_AS_WONT_FIX: {
                    if (status == IssueStatus.RESOLVED) {
                        return resolution != IssueResolution.WONT_FIX;
                    }
                    return true;
                }
                case RESOLVE_AS_FALSE_POSITIVE: {
                    if (status == IssueStatus.RESOLVED) {
                        return resolution != IssueResolution.FALSE_POSITIVE;
                    }
                    return true;
                }
                case REOPEN: {
                    if (status == IssueStatus.CLOSED) {
                        return resolution != IssueResolution.UNRESOLVED;
                    }
                    if (status == IssueStatus.RESOLVED) {
                        return resolution == IssueResolution.FIXED;
                    }
                    return true;
                }
                case CLOSE_AS_FIXED: {
                    if (status == IssueStatus.RESOLVED) {
                        return resolution == IssueResolution.FIXED;
                    }
                    return true;
                }
                case CLOSE_AS_WONT_FIX: {
                    if (status == IssueStatus.RESOLVED) {
                        return resolution == IssueResolution.WONT_FIX;
                    }
                    return true;
                }
                case CLOSE_AS_FALSE_POSITIVE: {
                    if (status == IssueStatus.RESOLVED) {
                        return resolution == IssueResolution.FALSE_POSITIVE;
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public IssueStatus getTargetStatus() {
        return this.targetStatus;
    }

    public IssueResolution getTargetResolution() {
        return this.targetResolution;
    }

    public static Set<IssueTransition> getTransitionsFrom(IssueStatus status, IssueResolution resolution) {
        EnumSet<IssueTransition> set = EnumSet.noneOf(IssueTransition.class);
        for (IssueTransition transition : IssueTransition.values()) {
            if (!transition.isValidSource(status, resolution)) continue;
            set.add(transition);
        }
        return set;
    }
}

