package cdc.issues;

import java.util.Objects;

public final class Param {
    private final String name;
    private final String value;

    private Param(String name,
                  String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name,
                            value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Param)) {
            return false;
        }
        final Param other = (Param) object;
        return Objects.equals(name, other.name)
                && Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "[" + name + "=" + value + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String value;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Param build() {
            return new Param(name,
                             value);
        }
    }
}