package cdc.issues.rules;

import java.util.Spliterator;

import cdc.issues.locations.LocatedData;

public class DataSource<T> {
    private final Class<T> dataClass;
    private final Spliterator<LocatedData<T>> spliterator;

    public DataSource(Class<T> dataClass,
                      Spliterator<LocatedData<T>> spliterator) {
        this.dataClass = dataClass;
        this.spliterator = spliterator;
    }

    public Class<T> getDataClass() {
        return dataClass;
    }

    public Spliterator<LocatedData<T>> getSpliterator() {
        return spliterator;
    }
}