package cdc.issues;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

import org.junit.jupiter.api.Test;

import cdc.issues.io.IssuesFormat;
import cdc.issues.rules.Rule;

class RuleTest {

    @Test
    void test() {
        final Rule rule1 = Rule.builder()
                               .domain("Domain")
                               .name("Name")
                               .addSeverity(IssueSeverity.BLOCKER)
                               .description("Description")
                               .build();

        final Rule rule2 = Rule.builder()
                               .domain("Domain")
                               .name("Name")
                               .addSeverity(IssueSeverity.BLOCKER)
                               .description("Description")
                               .build();
        final Rule rule3 = Rule.builder()
                               .domain("Domain")
                               .name(IssuesFormat.CSV)
                               .addSeverity(IssueSeverity.BLOCKER)
                               .description("Description")
                               .build();

        assertThrows(IllegalArgumentException.class,
                     () -> {
                         Rule.builder()
                             .domain("Domain")
                             .name("Name")
                             .description("Description")
                             .build();
                     });

        assertEquals(rule1, rule1);
        assertEquals(rule1, rule2);
        assertNotEquals(rule1, rule3);
        assertNotEquals(rule1, null);
        assertNotEquals(rule1, "Hello");
        assertEquals(rule1.hashCode(), rule2.hashCode());
        assertEquals(rule1.getId(), rule2.getId());

        assertEquals("Description", rule1.getDescription());
        assertEquals("Domain", rule1.getDomain());
        assertEquals("Name", rule1.getName());
        assertEquals(IssueSeverity.BLOCKER, rule1.getSeverities().iterator().next());
        assertEquals(IssuesFormat.CSV, rule3.getName(IssuesFormat.class));
    }
}