package cdc.issues;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * Utilities dedicated to issues.
 *
 * @author Damien Carbonne
 */
public final class IssueUtils {
    private IssueUtils() {
    }

    /**
     * @param issues The collection of issues.
     * @return A set of meta names used in {@code issues}.
     */
    public static Set<String> getMetaNames(Collection<? extends Issue> issues) {
        final Set<String> set = new HashSet<>();
        for (final Issue issue : issues) {
            set.addAll(issue.getMetas().getNames());
        }
        return set;
    }

    /**
     * @param issues The collection of issues.
     * @return A set of param names used in {@code issues}.
     */
    public static Set<String> getParamNames(Collection<? extends Issue> issues) {
        final Set<String> set = new HashSet<>();
        for (final Issue issue : issues) {
            set.addAll(issue.getParams().getNames());
        }
        return set;
    }
}