package cdc.issues.locations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import cdc.util.lang.Checks;

/**
 * Default implementation of {@link LocatedData}.
 *
 * @author Damien Carbonne
 *
 * @param <T> The data type.
 */
public class DefaultLocatedData<T> implements LocatedData<T> {
    private final T data;
    private final List<Location> locations;

    public DefaultLocatedData(T data,
                              Location location) {
        Checks.isNotNull(location, "location");
        this.data = data;
        final List<Location> tmp = new ArrayList<>();
        tmp.add(location);
        this.locations = Collections.unmodifiableList(tmp);
    }

    public DefaultLocatedData(T data,
                              Location... locations) {
        Checks.isNotNullOrEmpty(locations, "locations");
        this.data = data;
        final List<Location> tmp = new ArrayList<>();
        Collections.addAll(tmp, locations);
        this.locations = Collections.unmodifiableList(tmp);
    }

    @Override
    public T getData() {
        return data;
    }

    @Override
    public List<Location> getLocations() {
        return locations;
    }

    @Override
    public int hashCode() {
        return Objects.hash(data,
                            locations);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultLocatedData)) {
            return false;
        }
        final DefaultLocatedData<?> other = (DefaultLocatedData<?>) object;
        return Objects.equals(this.data, other.data)
                && Objects.equals(this.locations, other.locations);
    }

    @Override
    public String toString() {
        return "[" + data + ", " + locations + "]";
    }
}