package cdc.issues.api;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultIssuesHandler implements IssuesHandler<Issue> {
    private static final Logger LOGGER = LogManager.getLogger(DefaultIssuesHandler.class);

    private final boolean verbose;

    public static final DefaultIssuesHandler VERBOSE = new DefaultIssuesHandler(true);
    public static final DefaultIssuesHandler QUIET = new DefaultIssuesHandler(false);

    public static <I extends Issue> IssuesHandler<I> get(boolean verbose) {
        if (verbose) {
            @SuppressWarnings("unchecked")
            final IssuesHandler<I> tmp = (IssuesHandler<I>) (VERBOSE);
            return tmp;
        } else {
            @SuppressWarnings("unchecked")
            final IssuesHandler<I> tmp = (IssuesHandler<I>) QUIET;
            return tmp;
        }
    }

    protected DefaultIssuesHandler(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void issue(Issue issue) {
        if (verbose) {
            if (issue.getSeverity() == IssueSeverity.INFO) {
                LOGGER.info(issue);
            } else if (issue.getSeverity() == IssueSeverity.MINOR) {
                LOGGER.warn(issue);
            } else if (issue.getSeverity() == IssueSeverity.CRITICAL) {
                LOGGER.error(issue);
            } else if (issue.getSeverity() == IssueSeverity.BLOCKER) {
                LOGGER.fatal(issue);
            }
        }
    }
}