package cdc.issues.api;

import java.io.File;

import cdc.util.files.Files;

/**
 * Enumeration of possible format for export.import of issues.
 * <p>
 * A format may be unsupported.
 *
 * @author Damien Carbonne
 */
public enum IssuesFormat {
    CSV,
    ODS,
    XLS,
    XLSM,
    XLSX,
    JSON,
    XML;

    @SuppressWarnings("static-method")
    public boolean isExportFormat() {
        return true;
    }

    public boolean isImportFormat() {
        switch (this) {
        case CSV:
        case ODS:
        case XLS:
        case XLSM:
        case XLSX:
            return true;
        case XML:
        case JSON:
        default:
            return false;
        }
    }

    public static IssuesFormat from(File file) {
        final String ext = Files.getExtension(file);
        for (final IssuesFormat format : values()) {
            if (format.name().equalsIgnoreCase(ext)) {
                return format;
            }
        }
        return null;
    }
}