package cdc.issues.api;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Interface implemented by classes that can save Issues to a file.
 * <p>
 * One must use {@link IssuesFactory#createIssuesWriter(File)} to create
 * an instance of {@link IssuesWriter}.
 *
 * @author Damien Carbonne
 */
public interface IssuesWriter {
    /**
     * Saves a list of issues to a file.
     *
     * @param issues The list of issues.
     * @param file The file.
     * @throws IOException When an IO error occurs.
     */
    public void save(List<? extends Issue> issues,
                     File file) throws IOException;

    /**
     * Saves a list of issues to a file.
     *
     * @param issues The issues.
     * @param file The file.
     * @param features The features used to configure {@code file} generation.
     * @throws IOException When an IO error occurs.
     */
    public static void save(List<? extends Issue> issues,
                            File file,
                            IssuesFactoryFeatures features) throws IOException {
        final IssuesFactory factory = new IssuesFactory(features);
        final IssuesWriter writer = factory.createIssuesWriter(file);
        writer.save(issues, file);
    }
}