package cdc.issues.api.locations;

import java.util.Objects;

import cdc.issues.api.IssueLocation;

public abstract class AbstractIssueLocation implements IssueLocation {
    @Override
    public int hashCode() {
        return Objects.hash(getTargetId(),
                            getPath());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractIssueLocation)) {
            return false;
        }
        final AbstractIssueLocation other = (AbstractIssueLocation) object;
        return Objects.equals(this.getTargetId(), other.getTargetId())
                && Objects.equals(this.getPath(), other.getPath());
    }

    @Override
    public String toString() {
        return IssueLocation.toString(this);
    }
}