package cdc.issues;

public class IssuesTee<I extends Issue> implements IssuesHandler<I> {
    private final IssuesHandler<? super I>[] delegates;

    @SafeVarargs
    public IssuesTee(IssuesHandler<? super I>... delegates) {
        this.delegates = delegates.clone();
    }

    @Override
    public void issue(I issue) {
        for (final IssuesHandler<? super I> delegate : delegates) {
            delegate.issue(issue);
        }
    }
}