package cdc.issues.api;

/**
 * Interface implemented by classes that can handle (collect, process, ...) issues.
 *
 * @author Damien Carbonne
 *
 * @param <I> The issue type.
 */
public interface IssuesHandler<I extends Issue> {
    public static final IssuesHandler<Issue> VOID = VoidIssuesHandler.INSTANCE;

    /**
     * Notifies an issue.
     *
     * @param issue The issue.
     */
    public void issue(I issue);

    public default void issues(Iterable<? extends I> issues) {
        for (final I issue : issues) {
            issue(issue);
        }
    }
}