package cdc.issues;

public interface IssuesCountingHandler extends IssuesHandler, IssuesCountItem {

    /**
     * Converts an issues handler to a counting one.
     *
     * @param handler The issues handler.
     * @param computeHash If {@code true}, issues hash is computed.
     * @return A counting issues handler over {@code handler}.
     */
    public static IssuesCountingHandler of(IssuesHandler handler,
                                           boolean computeHash) {
        if (handler instanceof final IssuesCountingHandler x) {
            return x;
        } else {
            return new IssuesCountingHandler() {
                private final IssuesCounter counter = new IssuesCounter(computeHash);

                @Override
                public int getNumberOfIssues() {
                    return counter.getNumberOfIssues();
                }

                @Override
                public String getIssuesHash() {
                    return counter.getIssuesHash();
                }

                @Override
                public void issue(Issue issue) {
                    counter.consume(issue);
                    handler.issue(issue);
                }
            };
        }
    }
}