package cdc.issues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IssuesTee implements IssuesHandler {
    private final List<IssuesHandler> delegates = new ArrayList<>();

    public IssuesTee() {
    }

    public void add(IssuesHandler delegate) {
        this.delegates.add(delegate);
    }

    public void remove(IssuesHandler delegate) {
        this.delegates.remove(delegate);
    }

    @SafeVarargs
    public IssuesTee(IssuesHandler... delegates) {
        Collections.addAll(this.delegates, delegates);
    }

    @Override
    public void issue(Issue issue) {
        for (final IssuesHandler delegate : delegates) {
            delegate.issue(issue);
        }
    }
}