package cdc.issues;

import java.util.ArrayList;
import java.util.List;

import cdc.util.lang.Checks;

/**
 * A collector of issues that can transmit collected issues to a delegate.
 *
 * @author Damien Carbonne
 */
public class IssuesCollector implements IssuesCountingHandler {
    private final List<Issue> issues = new ArrayList<>();
    private String hash;
    @Deprecated(since = "2025-03-21", forRemoval = true)
    private final IssuesHandler delegate;

    @Deprecated(since = "2025-03-21", forRemoval = true)
    public IssuesCollector(IssuesHandler delegate) {
        this.delegate = Checks.isNotNull(delegate, "delegate");
    }

    public IssuesCollector() {
        this(IssuesHandler.VOID);
    }

    /**
     * @return The delegate (possibly {@code null}).
     */
    @Deprecated(since = "2025-03-21", forRemoval = true)
    public IssuesHandler getDelegate() {
        return delegate;
    }

    /**
     * Clears collected issues.
     */
    public void clear() {
        this.hash = null;
        this.issues.clear();
    }

    /**
     * @return The list of collected issues.
     */
    public List<Issue> getIssues() {
        return issues;
    }

    /**
     * Returns a list of issues having a severity.
     *
     * @param severity The severity.
     * @return A list of issues that have a certain {@code severity}.
     */
    public List<Issue> getIssues(IssueSeverity severity) {
        return issues.stream()
                     .filter(i -> i.getSeverity() == severity)
                     .toList();
    }

    @Override
    public void issue(Issue issue) {
        this.hash = null;
        this.issues.add(issue);
        delegate.issue(issue);
    }

    @Override
    public int getNumberOfIssues() {
        return issues.size();
    }

    @Override
    public String getIssuesHash() {
        if (hash == null) {
            hash = IssueUtils.getHash(issues);
        }
        return hash;
    }
}