package cdc.issues;

import java.util.ArrayList;
import java.util.List;

import cdc.util.lang.Checks;

/**
 * Implementation of {@link IssuesHandler} that can sample passed issues.
 *
 * @author Damien Carbonne
 */
public class IssuesSampler implements IssuesHandler {
    private final IssuesHandler delegate;
    private boolean enabled = false;
    private final List<Issue> samples = new ArrayList<>();

    public IssuesSampler(IssuesHandler delegate) {
        this.delegate = Checks.isNotNull(delegate, "delegate");
    }

    /**
     * @return The delegate.
     */
    public IssuesHandler getDelegate() {
        return delegate;
    }

    /**
     * @param enabled If {@code true} samples are stored. Otherwise they are ignored.
     */
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * @return {@code true} if samples are stored.
     */
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * Clear samples.
     */
    public void clear() {
        this.samples.clear();
    }

    /**
     * @return The current samples.
     */
    public List<Issue> getSamples() {
        return samples;
    }

    @Override
    public void issue(Issue issue) {
        delegate.issue(issue);
        if (enabled) {
            samples.add(issue);
        }
    }
}