package cdc.issues;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Effective parameters.
 *
 * @author Damien Carbonne
 */
public class Params {
    public static final Params NO_PARAMS = builder().build();

    private final Map<String, String> map = new HashMap<>();

    private Params(Map<String, String> map) {
        for (final Map.Entry<String, String> entry : map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    /**
     * @return The parameter names.
     */
    public Set<String> getNames() {
        return map.keySet();
    }

    /**
     * @return The sorted parameter names.
     */
    public List<String> getSortedNames() {
        return map.keySet()
                  .stream()
                  .sorted()
                  .collect(Collectors.toList());
    }

    /**
     * @param name The parameter name.
     * @return The value of parameter named {@code name}.
     */
    public String getValue(String name) {
        return map.get(name);
    }

    @Override
    public int hashCode() {
        return map.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Params)) {
            return false;
        }
        final Params other = (Params) object;
        return this.map.equals(other.map);
    }

    @Override
    public String toString() {
        return getSortedNames().stream()
                               .map(name -> name + ":" + getValue(name))
                               .collect(Collectors.joining(" ", "[", "]"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> map = new HashMap<>();

        private Builder() {
        }

        public Builder param(String name,
                             String value) {
            map.put(name, value);
            return this;
        }

        public Params build() {
            return new Params(map);
        }
    }
}