package cdc.issues.io;

import java.io.File;

import cdc.util.files.Files;

/**
 * Enumeration of possible format for export.import of issues.
 * <p>
 * A format may be unsupported.
 *
 * @author Damien Carbonne
 */
public enum IssuesFormat {
    CSV,
    ODS,
    XLS,
    XLSM,
    XLSX,
    JSON,
    XML;

    @SuppressWarnings("static-method")
    public boolean isExportFormat() {
        return true;
    }

    @SuppressWarnings("static-method")
    public boolean isImportFormat() {
        return true;
    }

    public static IssuesFormat from(File file) {
        final String ext = Files.getExtension(file);
        for (final IssuesFormat format : values()) {
            if (format.name().equalsIgnoreCase(ext)) {
                return format;
            }
        }
        return null;
    }
}