package cdc.issues.locations;

import java.util.Objects;

/**
 * Default implementation of {@link LocatedData}.
 *
 * @author Damien Carbonne
 *
 * @param <T> The data type.
 */
public class DefaultLocatedData<T> implements LocatedData<T> {
    private final T data;
    private final Location location;

    public DefaultLocatedData(T data,
                              Location location) {
        this.data = data;
        this.location = location;
    }

    @Override
    public T getData() {
        return data;
    }

    @Override
    public Location getLocation() {
        return location;
    }

    @Override
    public int hashCode() {
        return Objects.hash(data,
                            location);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultLocatedData)) {
            return false;
        }
        final DefaultLocatedData<?> other = (DefaultLocatedData<?>) object;
        return Objects.equals(this.data, other.data)
                && Objects.equals(this.location, other.location);
    }

    @Override
    public String toString() {
        return "[" + data + ", " + location + "]";
    }
}