package cdc.issues.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import cdc.issues.Issue;
import cdc.issues.Params;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.util.lang.Checks;

/**
 * Default implementation of {@link Snapshot}.
 *
 * @author Damien Carbonne
 */
public class SnapshotImpl implements Snapshot {
    private final ProjectImpl project;
    private String name;
    private Params metas = Params.NO_PARAMS;
    private Instant timestamp = Instant.now();
    private final List<Issue> issues = new ArrayList<>();

    public SnapshotImpl() {
        this(null);
    }

    SnapshotImpl(ProjectImpl project) {
        this.project = project;
        if (project != null) {
            project.addSnapshot(this);
        }
    }

    public SnapshotImpl setName(String name) {
        this.name = name;
        return this;
    }

    public SnapshotImpl setMetas(Params metas) {
        this.metas = Checks.isNotNull(metas, "metas");
        return this;
    }

    public SnapshotImpl setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SnapshotImpl addIssue(Issue issue) {
        issues.add(Checks.isNotNull(issue, "issue"));
        return this;
    }

    public SnapshotImpl addIssues(List<? extends Issue> issues) {
        this.issues.addAll(issues);
        return this;
    }

    @Override
    public Optional<Project> getProject() {
        return Optional.ofNullable(project);
    }

    @Override
    public Instant getTimestamp() {
        return timestamp;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Params getMetas() {
        return metas;
    }

    @Override
    public List<Issue> getIssues() {
        return issues;
    }
}