package cdc.issues.impl;

import java.time.Instant;
import java.util.Optional;

import cdc.issues.Params;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.io.SnapshotData;
import cdc.issues.rules.Profile;

/**
 * Default implementation of {@link SnapshotData}.
 *
 * @author Damien Carbonne
 */
public class SnapshotDataImpl implements SnapshotData {
    private String projectName;
    private String projectDescription;
    private Params projectMetas = Params.NO_PARAMS;
    private Profile profile;
    private String snapshotName;
    private String snapshotDescription;
    private Params snapshotMetas = Params.NO_PARAMS;
    private Instant snapshotTimestamp = Instant.now();
    private int numberOfIssues = -1;

    public SnapshotDataImpl() {
        super();
    }

    public SnapshotDataImpl(Snapshot snapshot) {
        final Project project = snapshot.getProject().orElse(null);
        setProjectName(project == null ? null : project.getName());
        setProjectDescription(project == null ? null : project.getDescription());
        setProjectMetas(project == null ? Params.NO_PARAMS : project.getMetas());
        setProfile(project == null ? null : project.getProfile().orElse(null));
        setSnapshotName(snapshot.getName());
        setSnapshotDescription(snapshot.getDescription());
        setSnapshotMetas(snapshot.getMetas());
        setSnapshotTimestamp(snapshot.getTimestamp());
    }

    public SnapshotDataImpl setProjectName(String name) {
        this.projectName = name;
        return this;
    }

    public SnapshotDataImpl setProjectDescription(String description) {
        this.projectDescription = description;
        return this;
    }

    public SnapshotDataImpl setProjectMetas(Params metas) {
        this.projectMetas = metas;
        return this;
    }

    public SnapshotDataImpl setProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    public SnapshotDataImpl setSnapshotName(String name) {
        this.snapshotName = name;
        return this;
    }

    public SnapshotDataImpl setSnapshotDescription(String description) {
        this.snapshotDescription = description;
        return this;
    }

    public SnapshotDataImpl setSnapshotMetas(Params metas) {
        this.snapshotMetas = metas;
        return this;
    }

    public SnapshotDataImpl setSnapshotTimestamp(Instant timestamp) {
        this.snapshotTimestamp = timestamp;
        return this;
    }

    public SnapshotDataImpl setNumberOfIssues(int number) {
        this.numberOfIssues = number;
        return this;
    }

    @Override
    public String getProjectName() {
        return projectName;
    }

    @Override
    public String getProjectDescription() {
        return projectDescription;
    }

    @Override
    public Params getProjectMetas() {
        return projectMetas;
    }

    @Override
    public Optional<? extends Profile> getProfile() {
        return Optional.ofNullable(profile);
    }

    @Override
    public String getSnapshotName() {
        return snapshotName;
    }

    @Override
    public String getSnapshotDescription() {
        return snapshotDescription;
    }

    @Override
    public Params getSnapshotMetas() {
        return snapshotMetas;
    }

    @Override
    public Instant getSnapshotTimestamp() {
        return snapshotTimestamp;
    }

    @Override
    public int getNumberOfIssues() {
        return numberOfIssues;
    }
}