/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.FormalArg;
import cdc.args.Necessity;

public class CompositeFormalArg<C, E>
extends FormalArg<C> {
    private final Class<E> elementType;

    public CompositeFormalArg(String name, Class<C> type, Class<E> elementType, Necessity necessity) {
        super(name, type, necessity);
        this.elementType = elementType;
    }

    public CompositeFormalArg(String name, Class<C> type, Class<E> elementType) {
        this(name, type, elementType, Necessity.MANDATORY);
    }

    public final Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.elementType.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompositeFormalArg)) {
            return false;
        }
        CompositeFormalArg o = (CompositeFormalArg)other;
        return super.equals(other) && this.elementType.equals(o.elementType);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getName());
        builder.append(" => ");
        builder.append(this.getType().getSimpleName());
        builder.append("<");
        builder.append(this.getElementType().getSimpleName());
        builder.append("> ");
        builder.append((Object)this.getNecessity());
        builder.append("]");
        return builder.toString();
    }
}

