/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.Arg;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.InvalidArgsException;
import cdc.args.Necessity;
import cdc.args.Strictness;
import cdc.util.lang.Checks;
import cdc.util.lang.Operators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Args {
    private static final Logger LOGGER = LogManager.getLogger(Args.class);
    private final Map<String, Arg> map;
    public static final Args NO_ARGS = new Args();

    public Args() {
        this.map = Collections.emptyMap();
    }

    public Args(Arg ... args) {
        Checks.isNotNull((Object)args, (String)"args");
        LinkedHashMap<String, Arg> tmp = new LinkedHashMap<String, Arg>();
        for (Arg arg : args) {
            Checks.isNotNull((Object)arg, (String)"args[?]");
            tmp.put(arg.getName(), arg);
        }
        this.map = Collections.unmodifiableMap(tmp);
    }

    public Args(List<Arg> args) {
        Checks.isNotNull(args, (String)"args");
        LinkedHashMap<String, Arg> tmp = new LinkedHashMap<String, Arg>();
        for (Arg arg : args) {
            Checks.isNotNull((Object)arg, (String)"args.get(?)");
            tmp.put(arg.getName(), arg);
        }
        this.map = Collections.unmodifiableMap(tmp);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isEmptyOrAllValuesAreNull() {
        if (this.map.isEmpty()) {
            return true;
        }
        for (Arg value : this.map.values()) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.map.size();
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.map.keySet()) {
            names.add(name);
        }
        return names;
    }

    public List<String> getSortedNames() {
        List<String> names = this.getNames();
        Collections.sort(names);
        return names;
    }

    public Arg getArg(String name) {
        return this.map.get(name);
    }

    public List<Arg> getArgs() {
        ArrayList<Arg> tmp = new ArrayList<Arg>();
        for (String name : this.map.keySet()) {
            tmp.add(this.getArg(name));
        }
        return tmp;
    }

    public boolean hasArg(String name) {
        return this.map.containsKey(name);
    }

    public boolean hasArgWithMatchingName(FormalArg<?> farg) {
        Checks.isNotNull(farg, (String)"farg");
        return this.map.containsKey(farg.getName());
    }

    public Args set(Args other) {
        Checks.isNotNull((Object)other, (String)"other");
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        return Args.builder().args(this).args(other).build();
    }

    public Object getValue(String name, Object def) {
        Checks.isNotNull((Object)name, (String)"name");
        Arg arg = this.map.get(name);
        return arg == null ? def : arg.getValue();
    }

    public Object getValue(String name) {
        return this.getValue(name, (Object)null);
    }

    public <T> T getValue(FormalArg<T> farg, T def) {
        Checks.isNotNull(farg, (String)"farg");
        return farg.getWrappedType().cast(this.getValue(farg.getName(), def));
    }

    public <T> T getValue(FormalArg<T> farg) {
        Checks.isNotNull(farg, (String)"farg");
        return this.getValue(farg, null);
    }

    public <T> T getValue(String name, Class<T> cls, T def) {
        Checks.isNotNull((Object)name, (String)"name");
        Checks.isNotNull(cls, (String)"cls");
        return cls.cast(this.getValue(name, def));
    }

    public <T> T getValue(String name, Class<T> cls) {
        return this.getValue(name, cls, null);
    }

    private boolean allArgsAreCompliant(FormalArgs fargs, Strictness strictness) {
        Checks.isNotNull((Object)fargs, (String)"fargs");
        Checks.isNotNull((Object)((Object)strictness), (String)"strictness");
        for (String name : this.getNames()) {
            Object value = this.getValue(name);
            FormalArg<?> farg = fargs.getArg(name);
            if (farg == null) {
                if (strictness != Strictness.STRICT) continue;
                LOGGER.debug("Unexpected effective arg name: {}", (Object)name);
                return false;
            }
            if (farg.isCompliantWith(value)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Non compliant value: '{}' for: '{}', expected class: '{}'", (Object)Operators.toStringWithClass((Object)value), (Object)name, (Object)farg.getType().getCanonicalName());
            }
            return false;
        }
        return true;
    }

    private boolean allMandatoryFormalArgsAreSet(FormalArgs fargs) {
        Checks.isNotNull((Object)fargs, (String)"fargs");
        for (FormalArg<?> farg : fargs.getArgs()) {
            if (!farg.isMandatory() || this.hasArg(farg.getName())) continue;
            LOGGER.debug("Missing mandatory formal arg: {} to: {}", farg, (Object)this);
            return false;
        }
        return true;
    }

    public boolean isCompliantWith(FormalArgs fargs, Strictness strictness) {
        Checks.isNotNull((Object)fargs, (String)"fargs");
        return this.allArgsAreCompliant(fargs, strictness) && this.allMandatoryFormalArgsAreSet(fargs);
    }

    public boolean isLooselyCompliantWith(FormalArgs fargs) {
        return this.isCompliantWith(fargs, Strictness.LOOSE);
    }

    public boolean isStrictlyCompliantWith(FormalArgs fargs) {
        return this.isCompliantWith(fargs, Strictness.STRICT);
    }

    public boolean isConflictingWith(FormalArgs fargs) {
        return !this.allArgsAreCompliant(fargs, Strictness.LOOSE);
    }

    public boolean isCompliantWithOneOf(Strictness strictness, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)((Object)strictness), (String)"strictness");
        Checks.isNotNull(collection, (String)"collection");
        for (FormalArgs fargs : collection) {
            if (!this.isCompliantWith(fargs, strictness)) continue;
            return true;
        }
        return false;
    }

    public boolean isLooselyCompliantWithOneOf(Collection<FormalArgs> collection) {
        Checks.isNotNull(collection, (String)"collection");
        return this.isCompliantWithOneOf(Strictness.LOOSE, collection);
    }

    public boolean isStrictlyCompliantWithOneOf(Collection<FormalArgs> collection) {
        Checks.isNotNull(collection, (String)"collection");
        return this.isCompliantWithOneOf(Strictness.STRICT, collection);
    }

    public boolean isCompliantWithOneOf(Strictness strictness, FormalArgs ... array) {
        Checks.isNotNull((Object)((Object)strictness), (String)"strictness");
        Checks.isNotNull((Object)array, (String)"array");
        for (FormalArgs fargs : array) {
            if (!this.isCompliantWith(fargs, strictness)) continue;
            return true;
        }
        return false;
    }

    public boolean isLooselyCompliantWithOneOf(FormalArgs ... array) {
        Checks.isNotNull((Object)array, (String)"array");
        return this.isCompliantWithOneOf(Strictness.LOOSE, array);
    }

    public boolean isStrictlyCompliantWithOneOf(FormalArgs ... array) {
        Checks.isNotNull((Object)array, (String)"array");
        return this.isCompliantWithOneOf(Strictness.STRICT, array);
    }

    public void checkComplianceWithOneOf(Strictness strictness, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)((Object)strictness), (String)"strictness");
        Checks.isNotNull(collection, (String)"collection");
        if (!this.isCompliantWithOneOf(strictness, collection)) {
            throw new InvalidArgsException(this + " is not " + (Object)((Object)strictness) + " compliant with one of " + collection);
        }
    }

    public void checkLooseComplianceWithOneOf(Collection<FormalArgs> collection) {
        Checks.isNotNull(collection, (String)"collection");
        this.checkComplianceWithOneOf(Strictness.LOOSE, collection);
    }

    public void checkStrictComplianceWithOneOf(Collection<FormalArgs> collection) {
        Checks.isNotNull(collection, (String)"collection");
        this.checkComplianceWithOneOf(Strictness.STRICT, collection);
    }

    public void checkComplianceWithOneOf(Strictness strictness, FormalArgs ... array) {
        Checks.isNotNull((Object)((Object)strictness), (String)"strictness");
        Checks.isNotNull((Object)array, (String)"array");
        if (!this.isCompliantWithOneOf(strictness, array)) {
            throw new InvalidArgsException(this + " is not " + (Object)((Object)strictness) + " compliant with one of " + Arrays.toString(array));
        }
    }

    public void checkLooseComplianceWithOneOf(FormalArgs ... array) {
        Checks.isNotNull((Object)array, (String)"array");
        this.checkComplianceWithOneOf(Strictness.LOOSE, array);
    }

    public void checkStrictComplianceWithOneOf(FormalArgs ... array) {
        Checks.isNotNull((Object)array, (String)"array");
        this.checkComplianceWithOneOf(Strictness.STRICT, array);
    }

    public static boolean areCompliant(Args args, FormalArgs fargs, Strictness strictness) {
        Checks.isNotNull((Object)args, (String)"args");
        Checks.isNotNull((Object)fargs, (String)"fargs");
        Checks.isNotNull((Object)((Object)strictness), (String)"strictness");
        return args.isCompliantWith(fargs, strictness);
    }

    public static boolean areLooselyCompliant(Args args, FormalArgs fargs) {
        Checks.isNotNull((Object)args, (String)"args");
        Checks.isNotNull((Object)fargs, (String)"fargs");
        return args.isLooselyCompliantWith(fargs);
    }

    public static boolean areStrictlyCompliant(Args args, FormalArgs fargs) {
        Checks.isNotNull((Object)args, (String)"args");
        Checks.isNotNull((Object)fargs, (String)"fargs");
        return args.isStrictlyCompliantWith(fargs);
    }

    public static boolean areCompliant(Args args, Strictness strictness, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)args, (String)"args");
        return args.isCompliantWithOneOf(strictness, collection);
    }

    public static boolean areLooselyCompliant(Args args, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)args, (String)"args");
        return args.isLooselyCompliantWithOneOf(collection);
    }

    public static boolean areStrictlyCompliant(Args args, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)args, (String)"args");
        return args.isStrictlyCompliantWithOneOf(collection);
    }

    public static boolean areCompliant(Args args, Strictness strictness, FormalArgs ... array) {
        Checks.isNotNull((Object)args, (String)"args");
        return args.isCompliantWithOneOf(strictness, array);
    }

    public static boolean areLooselyCompliant(Args args, FormalArgs ... array) {
        Checks.isNotNull((Object)args, (String)"args");
        return args.isLooselyCompliantWithOneOf(array);
    }

    public static boolean areStrictlyCompliant(Args args, FormalArgs ... array) {
        Checks.isNotNull((Object)args, (String)"args");
        return args.isStrictlyCompliantWithOneOf(array);
    }

    public static void checkCompliance(Args args, Strictness strictness, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)args, (String)"args");
        args.checkComplianceWithOneOf(strictness, collection);
    }

    public static void checkLooseCompliance(Args args, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)args, (String)"args");
        args.checkLooseComplianceWithOneOf(collection);
    }

    public static void checkStrictCompliance(Args args, Collection<FormalArgs> collection) {
        Checks.isNotNull((Object)args, (String)"args");
        args.checkStrictComplianceWithOneOf(collection);
    }

    public static void checkCompliance(Args args, Strictness strictness, FormalArgs ... array) {
        Checks.isNotNull((Object)args, (String)"args");
        args.checkComplianceWithOneOf(strictness, array);
    }

    public static void checkLooseCompliance(Args args, FormalArgs ... array) {
        Checks.isNotNull((Object)args, (String)"args");
        args.checkLooseComplianceWithOneOf(array);
    }

    public static void checkStrictCompliance(Args args, FormalArgs ... array) {
        Checks.isNotNull((Object)args, (String)"args");
        args.checkStrictComplianceWithOneOf(array);
    }

    public static FormalArgs reduceNecessity(FormalArgs fargs, Args args) {
        Checks.isNotNull((Object)fargs, (String)"fargs");
        Checks.isNotNull((Object)args, (String)"args");
        if (args.isConflictingWith(fargs)) {
            throw new IllegalArgumentException("Conflict between " + fargs + " and " + args);
        }
        if (!fargs.hasArgs(Necessity.MANDATORY) || args.isEmpty()) {
            return fargs;
        }
        ArrayList tmp = new ArrayList();
        for (FormalArg<?> farg : fargs.getArgs()) {
            if (farg.isOptional() || !args.hasArgWithMatchingName(farg)) {
                tmp.add(farg);
                continue;
            }
            tmp.add(new FormalArg(farg.getName(), farg.getType(), Necessity.OPTIONAL));
        }
        return new FormalArgs(tmp);
    }

    public int hashCode() {
        int result = 0;
        for (String name : this.getNames()) {
            result += name.hashCode();
            Object value = this.getValue(name);
            if (value == null) continue;
            result += value.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Args)) {
            return false;
        }
        Args other = (Args)object;
        return this.map.equals(other.map);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        boolean first = true;
        for (Arg arg : this.map.values()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(arg.getName());
            builder.append(" => ");
            builder.append(arg.getValue());
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    public static Builder builder() {
        return Args.builder(null);
    }

    public static Builder builder(FormalArgs fargs) {
        return new Builder(fargs);
    }

    public static final class Builder {
        private final FormalArgs fargs;
        private final Map<String, Arg> args = new LinkedHashMap<String, Arg>();

        Builder(FormalArgs fargs) {
            this.fargs = fargs;
        }

        public Builder clear() {
            this.args.clear();
            return this;
        }

        public FormalArgs getFormalArgs() {
            return this.fargs;
        }

        public boolean hasArg(String name) {
            return this.args.containsKey(name);
        }

        public boolean hasArgMatchingName(FormalArg<?> farg) {
            return this.hasArg(farg.getName());
        }

        public Arg getArg(String name) {
            return this.args.get(name);
        }

        public Builder arg(Arg arg) {
            Checks.isNotNull((Object)arg, (String)"arg");
            if (this.fargs != null && !arg.isCompliantWith(this.fargs)) {
                throw new IllegalArgumentException("Arg " + arg + " is not compliant with " + this.fargs);
            }
            this.args.put(arg.getName(), arg);
            return this;
        }

        @Deprecated
        public Builder setArg(Arg arg) {
            return this.arg(arg);
        }

        public Builder arg(String name, Object value) {
            return this.arg(new Arg(name, value));
        }

        @Deprecated
        public Builder setArg(String name, Object value) {
            return this.arg(name, value);
        }

        public final <T> Builder arg(FormalArg<T> farg, T value) {
            Checks.isNotNull(farg, (String)"farg");
            if (farg.isOptional() && value == null) {
                return this;
            }
            return this.arg(new Arg(farg, value));
        }

        @Deprecated
        public final <T> Builder setArg(FormalArg<T> farg, T value) {
            return this.arg(farg, value);
        }

        public final Builder argRaw(FormalArg<?> farg, Object value) {
            Checks.isNotNull(farg, (String)"farg");
            if (farg.isOptional() && value == null) {
                return this;
            }
            if (farg.isCompliantWith(value)) {
                return this.arg(farg.getName(), value);
            }
            throw new IllegalArgumentException();
        }

        @Deprecated
        public final Builder setArgRaw(FormalArg<?> farg, Object value) {
            return this.argRaw(farg, value);
        }

        public Builder args(Args other) {
            Checks.isNotNull((Object)other, (String)"other");
            for (Arg arg : other.getArgs()) {
                this.arg(arg);
            }
            return this;
        }

        @Deprecated
        public Builder setArgs(Args other) {
            return this.args(other);
        }

        public Args build() {
            Arg[] tmp = new Arg[this.args.size()];
            int index = 0;
            Iterator<Arg> iterator = this.args.values().iterator();
            while (iterator.hasNext()) {
                Arg arg;
                tmp[index] = arg = iterator.next();
                ++index;
            }
            return new Args(tmp);
        }
    }
}

