/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.Necessity;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;

public class FormalArg<T> {
    private final String name;
    private final Class<T> type;
    private final Necessity necessity;
    private final String description;

    private FormalArg(String name, Class<T> type, Necessity necessity, String description) {
        FormalArg.checkName(name);
        Checks.isNotNull(type, (String)"type");
        Checks.isNotNull((Object)((Object)necessity), (String)"necessity");
        this.name = name;
        this.type = type;
        this.necessity = necessity;
        this.description = description;
    }

    public FormalArg(String name, Class<T> type, Necessity necessity) {
        this(name, type, necessity, null);
    }

    public FormalArg(String name, Class<T> type) {
        this(name, type, Necessity.MANDATORY);
    }

    public static boolean isValidName(String s) {
        return s != null;
    }

    public static void checkName(String name) {
        if (!FormalArg.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: '" + name + "'");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Class<T> getType() {
        return this.type;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Class<T> getWrappedType() {
        return Introspection.wrap(this.type);
    }

    public final Necessity getNecessity() {
        return this.necessity;
    }

    public final boolean isMandatory() {
        return this.necessity == Necessity.MANDATORY;
    }

    public final boolean isOptional() {
        return this.necessity == Necessity.OPTIONAL;
    }

    public final boolean isCompliantWith(Object value) {
        return value == null ? this.isOptional() : this.getWrappedType().isInstance(value);
    }

    public final boolean matchesName(String other) {
        return this.name.equals(other);
    }

    public final boolean hasWeakerType(Class<?> other) {
        return this.getWrappedType().isAssignableFrom(Introspection.wrap(other));
    }

    public final boolean hasWeakerNecessity(Necessity other) {
        return this.necessity.isWeakerThan(other);
    }

    public final boolean isWeakerThan(FormalArg<?> other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.matchesName(other.name) && this.hasWeakerType(other.type) && this.hasWeakerNecessity(other.necessity);
    }

    private static Class<?> mergeMostSpecialized(Class<?> cls1, Class<?> cls2) {
        Class result = Introspection.mostSpecialized(cls1, cls2);
        if (result == null) {
            throw new IllegalArgumentException("Non compliant types: " + cls1.getSimpleName() + " " + cls2.getSimpleName());
        }
        return result;
    }

    public static FormalArg<?> merge(FormalArg<?> farg1, FormalArg<?> farg2, Necessity privileged) {
        if (farg1 == null) {
            return farg2;
        }
        if (farg2 == null) {
            return farg1;
        }
        if (!farg1.name.equals(farg2.name)) {
            throw new IllegalArgumentException("Non compliant names '" + farg1.name + "' '" + farg2.name + "'");
        }
        if (farg1.getNecessity() == farg2.getNecessity()) {
            return new FormalArg(farg1.getName(), FormalArg.mergeMostSpecialized(farg1.getType(), farg2.getType()), farg1.getNecessity());
        }
        return new FormalArg(farg1.getName(), FormalArg.mergeMostSpecialized(farg1.getType(), farg2.getType()), privileged);
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode() + this.necessity.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FormalArg)) {
            return false;
        }
        FormalArg o = (FormalArg)other;
        return this.name.equals(o.name) && this.type.equals(o.type) && this.necessity.equals((Object)o.necessity);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.name);
        builder.append(" => ");
        builder.append(this.type.getSimpleName());
        builder.append(" ");
        builder.append((Object)this.necessity);
        builder.append("]");
        return builder.toString();
    }

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder<T>(type);
    }

    public static class Builder<T> {
        private String name;
        private final Class<T> type;
        private Necessity necessity = Necessity.MANDATORY;
        private String description = null;

        protected Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> necessity(Necessity necessity) {
            this.necessity = necessity;
            return this;
        }

        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        public FormalArg<T> build() {
            return new FormalArg<T>(this.name, this.type, this.necessity, this.description);
        }
    }
}

