/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.FormalArg;
import cdc.args.Necessity;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class FormalArgs {
    private final FormalArg<?>[] args;
    public static final FormalArgs NO_FARGS = new FormalArgs();
    public static final List<FormalArgs> DEFAULT_FARGS_LIST = List.of(NO_FARGS);

    public FormalArgs() {
        this.args = new FormalArg[0];
    }

    public FormalArgs(FormalArg<?> ... args) {
        Checks.isNotNull(args, (String)"args");
        this.args = new FormalArg[args.length];
        for (int index = 0; index < args.length; ++index) {
            this.args[index] = args[index];
        }
        this.check();
    }

    public FormalArgs(List<FormalArg<?>> args) {
        Checks.isNotNull(args, (String)"args");
        this.args = new FormalArg[args.size()];
        for (int index = 0; index < args.size(); ++index) {
            this.args[index] = args.get(index);
        }
        this.check();
    }

    public FormalArgs(FormalArgs fargs1, FormalArgs fargs2) {
        int index;
        Checks.isNotNull((Object)fargs1, (String)"fargs1");
        Checks.isNotNull((Object)fargs2, (String)"fargs2");
        this.args = new FormalArg[fargs1.args.length + fargs2.args.length];
        for (index = 0; index < fargs1.args.length; ++index) {
            this.args[index] = fargs1.args[index];
        }
        for (index = 0; index < fargs2.args.length; ++index) {
            this.args[fargs1.args.length + index] = fargs2.args[index];
        }
        this.check();
    }

    private void check() {
        HashSet<String> names = new HashSet<String>();
        for (FormalArg<?> arg : this.args) {
            Checks.isNotNull(arg, (String)"arg");
            String name = arg.getName();
            if (names.contains(name)) {
                throw new IllegalArgumentException("Duplicate name: '" + name + "'");
            }
            names.add(name);
        }
    }

    public boolean isEmpty() {
        return this.args.length == 0;
    }

    public FormalArg<?>[] getArgs() {
        return this.args;
    }

    public boolean hasArgs(Necessity necessity) {
        for (FormalArg<?> arg : this.args) {
            if (arg.getNecessity() != necessity) continue;
            return true;
        }
        return false;
    }

    public FormalArgs getArgs(Necessity necessity) {
        Checks.isNotNull((Object)((Object)necessity), (String)"necessity");
        ArrayList tmp = new ArrayList();
        for (FormalArg<?> arg : this.args) {
            if (arg.getNecessity() != necessity) continue;
            tmp.add(arg);
        }
        if (tmp.isEmpty()) {
            return NO_FARGS;
        }
        return new FormalArgs(tmp);
    }

    public int size() {
        return this.args.length;
    }

    public FormalArg<?> getArg(int index) {
        return this.args[index];
    }

    public int getArgIndex(String name) {
        for (int index = 0; index < this.args.length; ++index) {
            if (!this.args[index].matchesName(name)) continue;
            return index;
        }
        return -1;
    }

    public FormalArg<?> getArg(String name) {
        int index = this.getArgIndex(name);
        if (index >= 0) {
            return this.getArg(index);
        }
        return null;
    }

    public boolean hasArg(String name) {
        return this.getArg(name) != null;
    }

    public boolean hasArgMatchingName(FormalArg<?> farg) {
        Checks.isNotNull(farg, (String)"farg");
        return this.hasArg(farg.getName());
    }

    public boolean accepts(FormalArgs other) {
        Checks.isNotNull((Object)other, (String)"other");
        for (FormalArg<?> arg : this.args) {
            FormalArg<?> oarg = other.getArg(arg.getName());
            if (!(oarg == null ? arg.isMandatory() : !arg.hasWeakerType(oarg.getType()))) continue;
            return false;
        }
        return true;
    }

    public static FormalArgs merge(FormalArgs fargs1, FormalArgs fargs2) {
        Checks.isNotNull((Object)fargs1, (String)"left");
        Checks.isNotNull((Object)fargs2, (String)"right");
        if (fargs1.isEmpty()) {
            return fargs2;
        }
        if (fargs2.isEmpty()) {
            return fargs1;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (FormalArg<?> farg : fargs1.args) {
            names.add(farg.getName());
        }
        for (FormalArg<?> farg : fargs2.args) {
            if (names.contains(farg.getName())) continue;
            names.add(farg.getName());
        }
        ArrayList fargs = new ArrayList();
        for (String name : names) {
            FormalArg<?> l = fargs1.getArg(name);
            FormalArg<?> r = fargs2.getArg(name);
            FormalArg<?> farg = FormalArg.merge(l, r, Necessity.MANDATORY);
            fargs.add(farg);
        }
        return new FormalArgs(fargs);
    }

    public static FormalArgs merge(FormalArgs ... all) {
        FormalArgs result = NO_FARGS;
        for (FormalArgs fargs : all) {
            result = FormalArgs.merge(result, fargs);
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        for (FormalArg<?> arg : this.args) {
            result += arg.hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FormalArgs)) {
            return false;
        }
        FormalArgs o = (FormalArgs)other;
        return Arrays.equals(this.args, o.args);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        boolean first = true;
        for (FormalArg<?> arg : this.args) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(arg);
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<FormalArg<?>> args = new ArrayList();

        Builder() {
        }

        public Builder clear() {
            this.args.clear();
            return this;
        }

        public Builder add(FormalArg<?> farg) {
            this.args.add(farg);
            return this;
        }

        public Builder add(String name, Class<?> type, Necessity necessity) {
            this.args.add(new FormalArg(name, type, necessity));
            return this;
        }

        public FormalArgs build() {
            return new FormalArgs(this.args);
        }
    }
}

