/*
 * Decompiled with CFR 0.152.
 */
package cdc.prefs;

import cdc.prefs.Preference;
import java.util.function.Function;
import java.util.prefs.Preferences;

public abstract class AbstractPreference<T>
implements Preference<T> {
    private final Class<T> valueClass;
    private final Preferences node;
    private final String key;
    private final T def;
    private final Function<T, String> toString;
    private final Function<String, T> fromString;

    protected AbstractPreference(Class<T> valueClass, Preferences node, String key, T def, Function<T, String> toString, Function<String, T> fromString) {
        this.valueClass = valueClass;
        this.node = node;
        this.key = key;
        this.def = def;
        this.toString = toString;
        this.fromString = fromString;
    }

    protected AbstractPreference(Class<T> valueClass, Preferences node, String key, T def) {
        this(valueClass, node, key, def, null, null);
    }

    protected String toString(T value) {
        if (value == null) {
            return "";
        }
        if (this.toString != null) {
            return this.toString.apply(value);
        }
        throw new IllegalStateException();
    }

    protected T fromString(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (this.fromString != null) {
            return this.fromString.apply(s);
        }
        throw new IllegalStateException();
    }

    @Override
    public final Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public final Preferences getNode() {
        return this.node;
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final T getDefaultValue() {
        return this.def;
    }

    @Override
    public final void put(T value) {
        if (value == null) {
            this.getNode().put(this.getKey(), "");
        } else {
            this.getNode().put(this.getKey(), this.toString(value));
        }
    }

    @Override
    public final T get(T def) {
        String value = this.getNode().get(this.getKey(), null);
        if (value == null) {
            return def;
        }
        try {
            return this.fromString(value);
        }
        catch (Exception e) {
            return def;
        }
    }
}

