/*
 * Decompiled with CFR 0.152.
 */
package cdc.prefs.defaults;

import cdc.prefs.AbstractPreference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;

public class DatePreference
extends AbstractPreference<Date> {
    private final DateFormat format;

    public DatePreference(Preferences node, String key, Date def, String pattern) {
        super(Date.class, node, key, def);
        this.format = new SimpleDateFormat(pattern);
    }

    public DatePreference(Preferences node, String key, Date def, Format format) {
        this(node, key, def, format.getPattern());
    }

    @Override
    protected String toString(Date value) {
        return this.format.format(value);
    }

    @Override
    protected Date fromString(String s) {
        try {
            return this.format.parse(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static enum Format {
        DATE("yyyy-MM-dd"),
        TIME("HH:mm:ss"),
        DATE_TIME("yyyy-MM-dd HH:mm:ss");

        private final String pattern;

        private Format(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

