/*
 * Decompiled with CFR 0.152.
 */
package cdc.prefs.file;

import cdc.prefs.file.FilePreferencesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilePreferences
extends AbstractPreferences {
    private static final Logger LOGGER = LogManager.getLogger(FilePreferences.class);
    private final Map<String, String> root = new TreeMap<String, String>();
    private final Map<String, FilePreferences> children = new TreeMap<String, FilePreferences>();
    private boolean isRemoved = false;

    public FilePreferences(AbstractPreferences parent, String name) {
        super(parent, name);
        LOGGER.trace("<init>({}, {})", (Object)(parent == null ? "null" : parent.absolutePath()), (Object)name);
        try {
            this.sync();
        }
        catch (BackingStoreException e) {
            LOGGER.error("Unable to sync on creation of node {} {}", (Object)name, (Object)e);
        }
    }

    private void buildPath(StringBuilder builder) {
        FilePreferences parent = (FilePreferences)this.parent();
        if (parent != null) {
            parent.buildPath(builder);
            builder.append(this.name()).append('.');
        }
    }

    private String getPath() {
        StringBuilder builder = new StringBuilder();
        this.buildPath(builder);
        return builder.toString();
    }

    @Override
    protected void putSpi(String key, String value) {
        LOGGER.trace("putSpi({}, {})", (Object)key, (Object)value);
        this.root.put(key, value);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.error("Unable to flush after putting {} {}", (Object)key, (Object)e.getMessage());
        }
    }

    @Override
    protected String getSpi(String key) {
        LOGGER.trace("getSpi({})", (Object)key);
        return this.root.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        LOGGER.trace("removeSpi({})", (Object)key);
        this.root.remove(key);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.error("Unable to flush after removing {} {}", (Object)key, (Object)e.getMessage());
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        LOGGER.trace("removeNodeSpi()");
        this.isRemoved = true;
        this.flush();
    }

    @Override
    protected String[] keysSpi() {
        return this.root.keySet().toArray(new String[this.root.keySet().size()]);
    }

    @Override
    protected String[] childrenNamesSpi() {
        return this.children.keySet().toArray(new String[this.children.keySet().size()]);
    }

    @Override
    protected FilePreferences childSpi(String name) {
        LOGGER.trace("childSpi({})", (Object)name);
        FilePreferences child = this.children.get(name);
        if (child == null || child.isRemoved()) {
            child = new FilePreferences(this, name);
            this.children.put(name, child);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        LOGGER.trace("syncSpi()");
        if (this.isRemoved()) {
            return;
        }
        File file = FilePreferencesFactory.getPreferencesFile();
        if (!file.exists()) {
            return;
        }
        File file2 = file;
        synchronized (file2) {
            LOGGER.trace("load({})", (Object)file);
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(file);){
                properties.load(fis);
                String path = this.getPath();
                for (String key : properties.stringPropertyNames()) {
                    String subKey;
                    if (!key.startsWith(path) || (subKey = key.substring(path.length())).indexOf(46) != -1) continue;
                    this.root.put(subKey, properties.getProperty(key));
                }
            }
            catch (IOException e) {
                LOGGER.catching((Throwable)e);
                throw new BackingStoreException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        File file;
        LOGGER.trace("flushSpi()");
        File file2 = file = FilePreferencesFactory.getPreferencesFile();
        synchronized (file2) {
            Properties properties = new Properties();
            try {
                String path = this.getPath();
                if (file.exists()) {
                    try (FileInputStream fis = new FileInputStream(file);){
                        properties.load(fis);
                    }
                    ArrayList toRemove = new ArrayList();
                    for (String key : properties.stringPropertyNames()) {
                        String subKey;
                        if (!key.startsWith(path) || (subKey = key.substring(path.length())).indexOf(46) != -1) continue;
                        toRemove.add(key);
                    }
                    Iterator<String> iterator = toRemove.iterator();
                    while (iterator.hasNext()) {
                        String key;
                        key = iterator.next();
                        properties.remove(key);
                    }
                }
                if (!this.isRemoved) {
                    for (Map.Entry<String, String> entry : this.root.entrySet()) {
                        properties.setProperty(path + entry.getKey(), entry.getValue());
                    }
                }
                LOGGER.trace("save({})", (Object)file);
                try (FileOutputStream fos = new FileOutputStream(file);){
                    properties.store(fos, "FilePreferences");
                }
            }
            catch (IOException e) {
                LOGGER.catching((Throwable)e);
                throw new BackingStoreException(e);
            }
        }
    }
}

