/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.io;

import cdc.args.Args;
import cdc.args.Factories;
import cdc.args.io.ArgsIo;
import cdc.converters.Converter;
import cdc.converters.io.ConvertersIo;
import cdc.io.data.Element;
import cdc.io.data.util.AbstractResourceLoader;
import cdc.util.lang.FailureReaction;
import cdc.validation.checkers.Checker;
import cdc.validation.checkers.Checkers;
import cdc.validation.checkers.RawRefChecker;
import java.util.ArrayList;
import java.util.List;

public final class CheckersIo {
    public static final String AFTER = "after";
    public static final String AND = "and";
    public static final String CHECKER = "checker";
    public static final String CHECKERS = "checkers";
    public static final String CONVERTER = "converter";
    public static final String CLASS = "class";
    public static final String DEF = "def";
    public static final String NAME = "name";
    public static final String NOT = "not";
    public static final String OR = "or";
    public static final String REF = "ref";

    private CheckersIo() {
    }

    public static class DataLoader
    extends AbstractResourceLoader<Void> {
        private final ConvertersIo.DataLoader convertersLoader;
        private final ArgsIo.DataLoader argsLoader;

        public DataLoader(FailureReaction reaction) {
            super(reaction);
            this.convertersLoader = new ConvertersIo.DataLoader(reaction);
            this.argsLoader = new ArgsIo.DataLoader(reaction);
        }

        protected Void loadRoot(Element root) {
            this.loadAndRegisterNamedCheckers(root);
            return null;
        }

        private static Checker<?> and(List<Checker<?>> checkers) {
            Checker checker = null;
            for (Checker checker2 : checkers) {
                if (checker == null) {
                    checker = checker2;
                    continue;
                }
                checker = checker.andRaw(checker2);
            }
            return checker;
        }

        private static Checker<?> or(List<Checker<?>> checkers) {
            Checker checker = null;
            for (Checker checker2 : checkers) {
                if (checker == null) {
                    checker = checker2;
                    continue;
                }
                checker = checker.orRaw(checker2);
            }
            return checker;
        }

        public void loadAndRegisterNamedCheckers(Element element) {
            if (CheckersIo.CHECKERS.equals(element.getName())) {
                for (Element child : element.getElements()) {
                    if (CheckersIo.CHECKER.equals(child.getName())) {
                        this.loadAndRegisterNamedChecker(child);
                        continue;
                    }
                    this.unexpectedElement(child, new String[]{CheckersIo.CHECKER});
                }
            } else {
                this.unexpectedElement(element, new String[]{CheckersIo.CHECKERS});
            }
        }

        public void loadAndRegisterNamedChecker(Element element) {
            if (CheckersIo.CHECKER.equals(element.getName())) {
                if (element.getChildrenCount(Element.class) == 1) {
                    Checker<?> checker = this.loadChecker((Element)element.getChild(Element.class));
                    if (checker != null) {
                        String name = element.getAttributeValue(CheckersIo.NAME);
                        if (Checkers.hasChecker((String)name)) {
                            this.onError("A checker named '" + name + "' is already registered");
                        } else {
                            Checkers.register(checker, (String)name);
                        }
                    }
                } else {
                    this.onError("Exactly one child expected under " + element);
                }
            } else {
                this.unexpectedElement(element, new String[]{CheckersIo.CHECKER});
            }
        }

        public Checker<?> loadChildChecker(Element parent) {
            if (parent.getChildrenCount(Element.class) == 1) {
                Element child = (Element)parent.getChildAt(Element.class, 0);
                return this.loadChecker(child);
            }
            return (Checker)this.onError("No child checker found", null);
        }

        public Checker<?> loadChecker(Element element) {
            try {
                switch (element.getName()) {
                    case "after": {
                        Converter converter = this.convertersLoader.loadAnonymousConverter((Element)element.getChildAt(Element.class, 0));
                        Checker<?> checker = this.loadChecker((Element)element.getChildAt(Element.class, 1));
                        return checker.afterRaw(converter);
                    }
                    case "and": {
                        if (element.getChildrenCount(Element.class) == 0) {
                            return (Checker)this.onError("At least one child expected under and", null);
                        }
                        return DataLoader.and(this.loadChildrenCheckers(element));
                    }
                    case "or": {
                        if (element.getChildrenCount(Element.class) == 0) {
                            return (Checker)this.onError("At least one child expected under or", null);
                        }
                        return DataLoader.or(this.loadChildrenCheckers(element));
                    }
                    case "not": {
                        if (element.getChildrenCount(Element.class) == 1) {
                            return this.loadChecker((Element)element.getChild(Element.class)).negate();
                        }
                        return (Checker)this.onError("Exactly one child expected under not", null);
                    }
                    case "def": {
                        Args args = this.argsLoader.loadOptionalChildArgs(element);
                        String className = element.getAttributeValue(CheckersIo.CLASS);
                        return (Checker)Factories.create((String)className, (Args)args);
                    }
                    case "ref": {
                        String name = element.getAttributeValue(CheckersIo.NAME);
                        return new RawRefChecker(name);
                    }
                }
                this.unexpectedElement(element, new String[]{CheckersIo.AFTER, CheckersIo.AND, CheckersIo.OR, CheckersIo.NOT, CheckersIo.DEF, CheckersIo.REF});
                return null;
            }
            catch (RuntimeException e) {
                this.getLogger().error("loadChecker({}) failed", (Object)element);
                throw e;
            }
        }

        private List<Checker<?>> loadChildrenCheckers(Element element) {
            ArrayList result = new ArrayList();
            for (Element child : element.getElements()) {
                result.add(this.loadChecker(child));
            }
            return result;
        }
    }
}

