/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.validation.checkers.Checker;
import cdc.validation.checkers.defaults.ComparablesSupport;

public class IsInRange<T extends Comparable<T>>
implements Checker<T> {
    private final Class<T> valueClass;
    private final T min;
    private final T max;
    public static final FormalArg<Class> CLASS = ComparablesSupport.CLASS;
    public static final FormalArg<String> SMIN = ComparablesSupport.OPTIONAL_STRING_MIN;
    public static final FormalArg<String> SMAX = ComparablesSupport.OPTIONAL_STRING_MAX;
    public static final FormalArg<Comparable> CMIN = ComparablesSupport.OPTIONAL_COMPARABLE_MIN;
    public static final FormalArg<Comparable> CMAX = ComparablesSupport.OPTIONAL_COMPARABLE_MAX;
    public static final FormalArgs SFARGS = new FormalArgs(new FormalArg[]{CLASS, SMIN, SMAX});
    public static final FormalArgs CFARGS = new FormalArgs(new FormalArg[]{CLASS, CMIN, CMAX});
    public static final Factory<IsInRange> FACTORY = new AbstractFactory<IsInRange>(IsInRange.class, new FormalArgs[]{SFARGS, CFARGS}){

        protected IsInRange<?> create(Args args, FormalArgs fargs) {
            if (fargs.equals((Object)SFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable minValue = ComparablesSupport.getMinFromString(args, cls);
                Comparable maxValue = ComparablesSupport.getMaxFromString(args, cls);
                return new IsInRange<Comparable>(cls, minValue, maxValue);
            }
            if (fargs.equals((Object)CFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable minValue = ComparablesSupport.getMinFromComparable(args, cls);
                Comparable maxValue = ComparablesSupport.getMaxFromComparable(args, cls);
                return new IsInRange<Comparable>(cls, minValue, maxValue);
            }
            throw new IllegalArgumentException();
        }
    };

    public IsInRange(Class<T> valueClass, T min, T max) {
        if (min == null && max == null) {
            throw new IllegalArgumentException("At least one of min or max must be set.");
        }
        this.valueClass = valueClass;
        this.min = min;
        this.max = max;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean test(T value) {
        return !(value == null || this.min != null && value.compareTo(this.min) < 0 || this.max != null && value.compareTo(this.max) > 0);
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            if (this.min != null || this.max != null) {
                return (String)(this.min == null ? "" : this.min + "<=") + this.wrap(arg) + (String)(this.max == null ? "" : "<=" + this.max) + ComparablesSupport.valueInfo(arg, this);
            }
            return "empty range";
        }
        if (this.min != null && this.max != null) {
            return this.wrap(arg) + "<" + this.min + " or " + this.max + "<" + this.wrap(arg) + ComparablesSupport.valueInfo(arg, this);
        }
        if (this.min != null) {
            return this.wrap(arg) + "<" + this.min + ComparablesSupport.valueInfo(arg, this);
        }
        if (this.max != null) {
            return this.max + "<" + this.wrap(arg) + ComparablesSupport.valueInfo(arg, this);
        }
        return "empty range";
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public static IsInRange<String> from(String min, String max) {
        return new IsInRange<String>(String.class, min, max);
    }

    public static IsInRange<Character> from(char min, char max) {
        return new IsInRange<Character>(Character.class, Character.valueOf(min), Character.valueOf(max));
    }

    public static IsInRange<Double> from(double min, double max) {
        return new IsInRange<Double>(Double.class, min, max);
    }

    public static IsInRange<Float> from(float min, float max) {
        return new IsInRange<Float>(Float.class, Float.valueOf(min), Float.valueOf(max));
    }

    public static IsInRange<Long> from(long min, long max) {
        return new IsInRange<Long>(Long.class, min, max);
    }

    public static IsInRange<Integer> from(int min, int max) {
        return new IsInRange<Integer>(Integer.class, min, max);
    }

    public static IsInRange<Short> from(short min, short max) {
        return new IsInRange<Short>(Short.class, min, max);
    }

    public static IsInRange<Byte> from(byte min, byte max) {
        return new IsInRange<Byte>(Byte.class, min, max);
    }
}

